<?php namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Authenticatable;


class Alerte extends Model {
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'alertes';


	function getDateMesureAttribute() {

		$mesure=Mesure::find($this->id_mesure);
		if(!$mesure) return"";
		return $mesure->date;
	}

	function getRucheNomAttribute() {

		$mesure=Mesure::find($this->id_mesure);
		if(!$mesure) return"";
		return $mesure->NomRuche;
	}

	public function getNomCapteurAttribute() {
		$mesure=Mesure::find($this->id_mesure);
		if(!$mesure) return "";
		$capteur=Capteur::find($mesure->id_capteur);
		if(!$capteur) return "";
		return $capteur->nom;
	}

	public function getNomTypeMesureAttribute() {
		$mesure=Mesure::find($this->id_mesure);
		if(!$mesure) return "";
		$capteur=Capteur::find($mesure->id_capteur);
		if(!$capteur) return "";
		$type_capteur=TypeCapteur::find($capteur->id_type_capteur);
		return $type_capteur->nom;
	}

	function getDetailAttribute() {
		$txt="";$sep="<br/>";
		$mesure=Mesure::find($this->id_mesure);
		if(!$mesure) return"";
		$type=$mesure->NomTypeMesure;
		$niveau=$this->niveau;
		$t_niveau=explode(",",$niveau);
		$txt.=$type;
		if(count($t_niveau)==2) {
			if($t_niveau[1]=="H") $txt.=$sep."Dépassement de la valeur limite :".$t_niveau[0].$mesure->Unite;
			if($t_niveau[1]=="B") $txt.=$sep."En dessous de la valeur limite : ".$t_niveau[0].$mesure->Unite;

		}
		if($type=="ILS") {
			if($this->niveau==1) $txt.="<br>Ouverture du capot";
			else $txt.="<br>Fermeture du capot";
		}
		return $txt;
	}

}