<?php 

namespace App\Http\Controllers;

use Auth\AuthController;
use App\Mesure;
use App\Reception;
use App\Ruche;
use App\TypeCapteur;
use App\Capteur;
use App\Alerte;
use App\User;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use View;
use Illuminate\Http\Request;

/* CLASSE DES API */
class ApiDataLoadController extends Controller {
 

    public function __construct()
    {
        //$this->beforeFilter('auth');
    }
 
    public function loadPOSTData(Request $request)
    {
        //https://btssn.nc/btssn2/ruches/public/api/api_post_data
        //AC:67:B2:38:51:E0 ,32.50 ,65.00 ,1013.12 ,-0.05 ,LU ,2.80 ,1 ,50
        $reception=new Reception;
        $reception->data=$request->data;
        $sep=" ,";
        //$id=($request->id)?$request->id:"";

        //$t_capteurs[""=>""];
        $mac=($request->mac)?$request->mac:"";
        $temperature=($request->temperature)?$request->temperature:"";
        $humidite=($request->humidite)?$request->humidite:"";
        $pression=($request->pression)?$request->pression:"";
        $masse=($request->masse)?$request->masse:"";
        $luminosite=($request->luminosite)?$request->luminosite:"";
        $tlum=($request->tlum)?$request->tlum:"";
        $ouverture=($request->ouverture)?1:0;
        $tension=($request->tension)?$request->tension:"";

        $data=$mac.$sep.$temperature.$sep.$humidite.$sep.$pression.$sep.$masse.$sep.$luminosite.$sep.$tlum.$sep.$ouverture.$sep.$tension;
        $reception->data=$data;
        $reception->save();

        // data pour mettre dans mesures
        $this->Data2Mesure($reception->id);

        return "OK2";
    }



     public function Data2Mesure($id_reception)
    {
        $res=[];
        //Recherche des receptions qui ne sont pas dans mesures
        $reception=Reception::find($id_reception);

        //Decoupage des valeurs
        $data_receipt=$reception->data;
        $t_data=explode(',',$data_receipt);
        $mac=trim($t_data[0]);
        $date=$reception->created_at->format('Y-m-d H:i:s');
        $type_capteur=[];
        $ruche=Ruche::where("mac","=",$mac)->first(); //AC:67:B2:38:51:E0

        if($ruche) {
            //Temperature
            $type_capteur["T"]=TypeCapteur::where('nom','=','Temperature')->first();
            $valeur["T"]=$t_data[1];

            //Humidité
            $type_capteur["H"]=TypeCapteur::where('nom','=','Humidité')->first();
            $valeur["H"]=$t_data[2];

            //Pression
            $type_capteur["P"]=TypeCapteur::where('nom','=','Pression')->first();
            $valeur["P"]=$t_data[3];

            //Masse
            $type_capteur["M"]=TypeCapteur::where('nom','=','Masse')->first();
            $valeur["M"]=$t_data[4];


            //Luminosité
            $type_capteur["L"]=TypeCapteur::where('nom','=','Luminosité')->first();
            $valeur["L"]=$t_data[6];


            //OUverture
            $type_capteur["I"]=TypeCapteur::where('nom','=','ILS')->first();
            $valeur["I"]=$t_data[7];

            //Tension
            $type_capteur["U"]=TypeCapteur::where('nom','=','Tension')->first();
            $valeur["U"]=$t_data[8];


            //Alerte capot ouvert
            //Si Capot ouvert alors qu'il était fermé lors de la denrière reception => Alerte
            //REcherche dernièe valeur Capot
            $type_capteur_ils=TypeCapteur::where('nom','=','ILS')->first();
            $capteur=Capteur::where('id_type_capteur','=',$type_capteur_ils->id)->where('id_ruche','=',$ruche->id)->first();
            $last_mesure_ILS=Mesure::where('id_capteur','=', $capteur->id)->orderby('date','DESC')->first();
            $last_etat_capot=0;
            if($last_mesure_ILS) $last_etat_capot=$last_mesure_ILS->valeur;
            $new_etat_capot=$valeur["I"];
            //Si changement etat capot on ajoute la mesure de toute manière
            if($last_etat_capot!=$new_etat_capot) {
                $id_mesure=$this->insertMesure($capteur->id,$valeur["I"],$reception->id,$date);
                //On créé une alerte
                $email_date=date('Y-m-d H:i:s');
                $email_dest="toto@mail.nc";
                $id_alerte=$this->insertAlerte($id_mesure,$new_etat_capot,$email_date,$email_dest);
                return $id_alerte;
            }

            //Alerte capot ouvert

            foreach($type_capteur as $key=>$type) {
                $capteur=Capteur::where('id_type_capteur','=',$type->id)->where('id_ruche','=',$ruche->id)->first();
                //Données toutes les 6h
                //on ne prend que les data des heures : 0 - 6 - 12 et 18 date format YYYY-MM-DD HH:MM:SS
                $jour_heure=substr($date,0,13);
                $heure=substr($date,11,2);
                $nb_mesures_jourheure=Mesure::where('created_at','like',$jour_heure.'%')->count(); //Nombre de mesures déjà réalisées sur cette date-heure
                if($nb_mesures_jourheure==0) {
                    if( ($heure=="02") || ($heure=="09") || ($heure=="14") || ($heure=="20") ) //1er mesure de chaque periode de 6h
                        if($capteur) $res[]=$this->insertMesure($capteur->id,$valeur[$key],$reception->id,$date);
                }
            }  


        }

        return true;
    }




    public function insertAlerte($id_mesure,$niveau,$email_date,$email_dest)
    {
        $alert=new Alerte();
        $alert->id_mesure=$id_mesure;
        $alert->niveau=($niveau=="")?0:$niveau;
        $alert->email_date=$email_date;
        $alert->email_dest=$email_dest;
        $alert->save();
        return $alert->id;
    }


    public function insertMesure($id_capteur,$valeur,$id_reception,$date)
    {
        $mesure=new Mesure();
        $mesure->id_capteur=$id_capteur;
        $mesure->id_reception=$id_reception;
        $mesure->date=$date;
        $mesure->valeur=$valeur;
        $mesure->save();
        return $mesure->id;
    }



     public function loadGETData($data)
    {
        $reception=new Reception;
        $reception->data=$data;
        $reception->save();
    }



     public function ShowData()
    {

        $receptions=Reception::whereNotNull('id')->orderby('created_at','desc')->get();

        return View::make('receptions.index_api', [
            'receptions' => $receptions
        ]);
    }



     public function deleteData()
    {

        Reception::whereNotNull('id')->delete();

        $msg=" Lignes suprimées";
        return Redirect::back()->with('message', $msg);
    }


     public function ApiTDB()
    {

        $dashboard_title = "BTSSN2-2023";
        $t_indicateurs=[];

        
        //Indicateurs
        $nb_mesures=Mesure::count();
        $nb_receptions=Reception::count();
        $nb_ruches=Ruche::count();
        $nb_alertes=Alerte::count();

        $t_indicateurs["nb_mesures"]=$nb_mesures;
        $t_indicateurs["nb_receptions"]=$nb_receptions;
        $t_indicateurs["nb_alertes"]=$nb_alertes;
        $t_indicateurs["nb_ruches"]=$nb_ruches;

 
        $alertes=Alerte::orderby('id','desc')->get();

        //Pour chaque ruche
        $nbmax=122;
        $max=1;
        $t_dates=[];$t_data=[];
        $t_dates_temp=[];$t_data_temp=[];
        $ruches=[];
        $nb_ruches=2;

        $ruche=Ruche::find(6);
        $label_legend=$ruche->nom;
        $t_data_all=$this->getData2($ruche->id,$nbmax,$t_dates); 


        //MASSE
        $type_capteur=TypeCapteur::where('nom','=','Masse')->first();  //Masse
        $capteur=Capteur::where('id_ruche','=',$ruche->id)->where('id_type_capteur','=',$type_capteur->id)->first(); 
        foreach($t_data_all as $key=>$data) if(isset($data["Masse"])) $t_data_masse[]=$data["Masse"];

        //TEMPERATURE
        $t_data_temp=[];
        $type_capteur=TypeCapteur::where('nom','=','Temperature')->first(); //Temperature
        $capteur=Capteur::where('id_ruche','=',$ruche->id)->where('id_type_capteur','=',$type_capteur->id)->first();
        foreach($t_data_all as $key=>$data) if(isset($data["Temperature"])) $t_data_temp[]=$data["Temperature"];

        //PRESSION
        $t_data_pression=[];
        $type_capteur=TypeCapteur::where('nom','=','Pression')->first();  //Pression
        $capteur=Capteur::where('id_ruche','=',$ruche->id)->where('id_type_capteur','=',$type_capteur->id)->first(); 
        foreach($t_data_all as $key=>$data) if(isset($data["Pression"])) $t_data_pression[]=$data["Pression"];

        //HUMIDITE
        $t_data_humidite=[];
        $type_capteur=TypeCapteur::where('nom','=','Humidité')->first();  //Humidité
        $capteur=Capteur::where('id_ruche','=',$ruche->id)->where('id_type_capteur','=',$type_capteur->id)->first(); 
        foreach($t_data_all as $key=>$data) if(isset($data["Humidité"])) $t_data_humidite[]=$data["Humidité"];

        //LUMINOSITE
        $t_data_luminosite=[];
        $type_capteur=TypeCapteur::where('nom','=','Luminosité')->first();  //Luminosité
        $capteur=Capteur::where('id_ruche','=',$ruche->id)->where('id_type_capteur','=',$type_capteur->id)->first(); 
        foreach($t_data_all as $key=>$data) if(isset($data["Luminosité"])) $t_data_luminosite[]=$data["Luminosité"];

        //TENSION
        $t_data_tension=[];
        $type_capteur=TypeCapteur::where('nom','=','Tension')->first();  //Tension
        $capteur=Capteur::where('id_ruche','=',$ruche->id)->where('id_type_capteur','=',$type_capteur->id)->first(); 
        foreach($t_data_all as $key=>$data) if(isset($data["Tension"])) $t_data_tension[]=$data["Tension"];


        //Dates
        $t_labels=$t_dates;
        $labels_temp=$t_dates_temp;

        //Couleur des courbes
        $t_colors=[
            "Masse"=>"#1D5D9B","Temperature"=>"#3AA6B9",
            "Pression"=>"#75C2F6","Humidité"=>"#FF9EAA",
            "Luminosité"=>"#164B60","Tension"=>"#A2FF86"];
        $colors_temp="#ffb5c7";
        $colors="#ffb5c7";

        return view::make('dashboard_guest_api',[
            "alertes"=>$alertes,
            "dashboard_title"=>$dashboard_title,
            "t_indicateurs"=>$t_indicateurs,
            'label_legend' => $label_legend,'nb_ruches'=>$nb_ruches,'max' =>$max,
            't_data_all' => $t_data_all,
            't_dates_temp' => $t_dates_temp,'t_data_masse' => $t_data_masse,
            't_data_pression' => $t_data_pression,'t_data_humidite' => $t_data_humidite,
            't_data_luminosite' => $t_data_luminosite,'t_data_tension' => $t_data_tension,
            't_labels' => $t_labels,'colors' => $colors,"t_colors" =>$t_colors,
            't_data_temp' => $t_data_temp,'labels_temp' => $labels_temp,'colors_temp' => $colors_temp,
        ]);
    }

    //Pour tous les capteurs
     public function getData2($id_ruche,$nbmax,&$t_dates)
    {
        $lim=16;
        $t_data=[];
        $capteurs=Capteur::where('id_ruche','=',$id_ruche)->orderby('nom','asc')->get();

        foreach($capteurs as $capteur) {
            $mesures=Mesure::where('id_capteur','=',$capteur->id)->orderBy('date','ASC')->get();
            foreach($mesures as $mesure) {
                $date=substr($mesure->date,0,$lim);
                $t_data[$date][$capteur->NomTypeCapteur]=$mesure->valeur;
                if(!in_Array($date,$t_dates)) $t_dates[]=$date;
            }
        }

        return $t_data;
    }


     public function getData($id_ruche,$id_type_capteur,$nbmax,&$t_dates)
    {
        $lim=16;
        $t_data=[];
        $capteur=Capteur::where('id_ruche','=',$id_ruche)->where('id_type_capteur','=',$id_type_capteur)->first();
        if(!$capteur) return "";
        $mesures=Mesure::where('id_capteur','=',$capteur->id)->orderBy('date','ASC')->limit($nbmax)->get();

        foreach($mesures as $mesure) {
            $date=substr($mesure->date,0,$lim);
            $t_data[$date]=$mesure->valeur;
            if(!in_Array($date,$t_dates)) $t_dates[]=$date;
        }

        return $t_data;
    }
}



