<?php 

namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Role2;
use App\Capteur;
use App\Ruche;
use App\TypeCapteur;
//use App\Parametre;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use View;
use App\Http\Requests\CapteurRequest;

class CapteursController extends Controller {
 
    private $menu='capteurs';

    public function __construct()
    {
        //$this->beforeFilter('auth');
    }
 
    public function index()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

       $capteurs=Capteur::all();

        return View::make('capteurs.index', [
            'user'=>$user,'menu' => $this->menu,
            'capteurs' => $capteurs, 
            
            
        ]);
    }
 
    public function create()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        $liste_ruches=Ruche::select('id','nom')->orderby('nom','asc')->pluck('nom','id')->toArray();
        $liste_types_capteurs=TypeCapteur::select('id','nom')->orderby('nom','asc')->pluck('nom','id')->toArray();
        return View::make('capteurs.create',
            [
                'user' => $user,'menu' => $this->menu,
                'liste_ruches' => $liste_ruches,'liste_types_capteurs' => $liste_types_capteurs
            ]);

    }
 
    public function store(CapteurRequest $request)
    {
        $capteur = new Capteur;
 
        $capteur->nom = $request->nom;
        $capteur->id_ruche = $request->id_ruche;
        $capteur->id_type_capteur = $request->id_type_capteur;
        $capteur->alerte_haut = $request->alerte_haut;
        $capteur->alerte_bas = $request->alerte_bas;
        $capteur->save();

        return Redirect::to('/capteurs');
    }
 
    public function edit($id)
    {
        $user = Auth::user($id);
        if(!$user) return Redirect::route( 'login' );

        $capteur = Capteur::find($id);
        $liste_ruches=Ruche::select('id','nom')->orderby('nom','asc')->pluck('nom','id')->toArray();
        $liste_types_capteurs=TypeCapteur::select('id','nom')->orderby('nom','asc')->pluck('nom','id')->toArray();
        return View::make('capteurs.edit', 
            [ 
                'user' => $user,
                'menu' => $this->menu,
                'capteur' => $capteur,
                'liste_ruches' => $liste_ruches,'liste_types_capteurs' => $liste_types_capteurs
            ]);
    }
 

    public function update($id,CapteurRequest $request)
    {
        $capteur = Capteur::find($id);
        $capteur->nom = $request->nom;
        $capteur->id_ruche = $request->id_ruche;
        $capteur->id_type_capteur = $request->id_type_capteur;
        $capteur->alerte_haut = $request->alerte_haut;
        $capteur->alerte_bas = $request->alerte_bas;
        $capteur->save();

        return Redirect::to('/capteurs');
    }
 
    public function show($id)
    {
        $user = Auth::user($id);
        if(!$user) return Redirect::route( 'login' );

        $capteur = Capteur::find($id);
        $liste_ruches=Ruche::select('id','nom')->orderby('nom','asc')->pluck('nom','id')->toArray();
        $liste_types_capteurs=TypeCapteur::select('id','nom')->orderby('nom','asc')->pluck('nom','id')->toArray();
        return View::make('capteurs.show', 
            [ 
                'user' => $user,'menu' => $this->menu,
                'capteur' => $capteur,
                'liste_ruches' => $liste_ruches,'liste_types_capteurs' => $liste_types_capteurs
            ]);
    }

    public function destroy($id)
    {

        
        Capteur::destroy($id);
 
        return Redirect::to('/capteurs');
    }
 

}



