<?php

namespace App\Http\Controllers;

use View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\User;
use App\Role2;
use App\Permission2;
use App\Mesure;
use App\Reception;
use App\Ruche;
use App\Alerte;


class HomeController extends Controller
{

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */


    public function index()
    {
        $user = Auth::user();
        $dashboard_title = "BTSSN2-2021";
        $t_indicateurs=[];

        //Indicateurs
        $nb_users=User::count();
        $nb_roles=Role2::count();
        $nb_permissions=Permission2::count();
        $nb_mesures=Mesure::count();
        $nb_receptions=Reception::count();
        $nb_ruches=Ruche::count();
        $nb_alertes=Alerte::count();

        $t_indicateurs["nb_users"]=$nb_users;
        $t_indicateurs["nb_roles"]=$nb_roles;
        $t_indicateurs["nb_permissions"]=$nb_permissions;
        $t_indicateurs["nb_mesures"]=$nb_mesures;
        $t_indicateurs["nb_receptions"]=$nb_receptions;
        $t_indicateurs["nb_alertes"]=$nb_alertes;
        $t_indicateurs["nb_ruches"]=$nb_ruches;



        $users=User::all();

        return view::make('home_Administrateur',[
            "user"=>$user,
            "users"=>$users,
            "dashboard_title"=>$dashboard_title,
            "t_indicateurs"=>$t_indicateurs,
        ]);
    }


}
