<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Role2;
use App\Mesure;
use App\Capteur;
use App\TypeCapteur;
use App\Ruche;
//use App\Parametre;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use View;
use App\Http\Requests\MesureRequest;
use Illuminate\Http\Request;


class MesuresController extends Controller {
 
    private $menu='mesures';

    public function __construct()
    {
        //$this->beforeFilter('auth');
    }
 
    public function index($t_id_ruche="",$id_type_capteur="")
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        $nbmax=500;
        $max=1;
        $t_dates=[];  
        $ruches=[];
        $nb_ruches=0;
        

        //Ruche
        if($t_id_ruche=="") {
            $ruches=Ruche::orderby('nom','asc')->limit(1)->get();
            $ruche=Ruche::orderby('nom','asc')->first();
            $t_id_ruche=[];
            $t_id_ruche[]=$ruche->id;
        }
        else {
            $ruches=Ruche::whereIn('id',$t_id_ruche)->get();
        }

        //$ruche=$ruches->first();
        //$id_ruche=$ruche->id;

        //TypeCapteur
        if($id_type_capteur=="") $type_capteur=TypeCapteur::first();
        else $type_capteur=TypeCapteur::find($id_type_capteur);

        //Pour chaque ruche
        foreach($ruches as $ruche) {

            //Capteur
            $capteur=Capteur::where('id_ruche','=',$ruche->id)->where('id_type_capteur','=',$type_capteur->id)->first();

            //Data 
            $all_mesures[$ruche->id]=Mesure::where('id_capteur',$capteur->id)->orderBy('date','ASC')->limit($nbmax)->get();
            
            //Graphique
            $t_data[]=$this->getData($ruche->id,$type_capteur->id,$nbmax,$t_dates); 
            //foreach($t_data[$nb_ruches] as $key=>$value)

            $t_label_legend[]=$ruche->nom;
            $nb_ruches++;
        }

        $liste_ruches=Ruche::select('id','nom')->orderby('nom','asc')->pluck('nom','id')->toArray();
        $liste_type_capteur=TypeCapteur::select('id','nom')->orderby('nom','asc')->pluck('nom','id')->toArray();

        $nom_type_capteur=$type_capteur->nom;
        $mesures=[];
        foreach($all_mesures as $id_ruche=>$list_mesures) {
            foreach($list_mesures as $mesure) {
                if(!isset($mesures[$mesure->date])) $mesures[$mesure->date]="";
                $mesures[$mesure->date].=(($mesures[$mesure->date]=="")?"":"~").$mesure->valeur;
                //$mesures[$mesure->date]=[$id_ruche,$mesure->valeur];
            }
        }
        //Dates
        $t_labels=$t_dates;
        //Couleur des courbes
        $t_colors=["blue","green","#0c7bff","#cc4cca"];
 

        return View::make('mesures.index', [
            'user'=>$user,
            'ruches'=>$ruches,
            't_id_ruche' => $t_id_ruche,
            'nb_ruches'=>$nb_ruches,
            'capteur'=>$capteur,
            'type_capteur'=>$type_capteur,
            't_colors' => $t_colors,
            'liste_ruches' => $liste_ruches,
            'liste_type_capteur' => $liste_type_capteur,
            'menu' => $this->menu,
            'mesures' => $mesures, 
            't_labels' => $t_labels,
            't_data' => $t_data,
            'max' =>$max,
            't_label_legend' => $t_label_legend,
            'nom_type_capteur' => $nom_type_capteur
        ]);
    }


    public function index_filtre_get($id_ruche,$id_type_capteur) {
        $t_id_ruche[]=$id_ruche;
        return $this->index($t_id_ruche,$id_type_capteur);
    }

    public function index_filtre_post(Request $request) {
        $t_id_ruche=$request->select_ruche;
        $id_type_capteur=$request->select_type_capteur;
        return $this->index($t_id_ruche,$id_type_capteur);
    }

 
     public function getData($id_ruche,$id_type_capteur,$nbmax,&$t_dates)
    {
        $t_data=[];
        $capteur=Capteur::where('id_ruche','=',$id_ruche)->where('id_type_capteur','=',$id_type_capteur)->first();
        if(!$capteur) return "";
        $mesures=Mesure::where('id_capteur','=',$capteur->id)->orderBy('date','DESC')->limit($nbmax)->get();

        foreach($mesures as $mesure) {
            $t_data[]=$mesure->valeur;
            if(!in_Array(substr($mesure->date,0,13),$t_dates)) $t_dates[]=substr($mesure->date,0,13);
        }

        return $t_data;
    }



    public function create()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        return View::make('mesures.create',
            [
                'user' => $user,'menu' => $this->menu
            ]);

    }
 
    public function store(MesureRequest $request)
    {
        $mesure = new Mesure;
 
        $mesure->nom = $request->nom;
        $mesure->gps = $request->gps;
        $mesure->save();

        return Redirect::to('/mesures');
    }
 
    public function edit($id)
    {
        $user = Auth::user($id);
        if(!$user) return Redirect::route( 'login' );

        $mesure = Mesure::find($id);

        return View::make('mesures.edit', 
            [ 
                'user' => $user,'menu' => $this->menu,
                'mesure' => $mesure,
            ]);
    }
 

    public function update($id,MesureRequest $request)
    {
        $mesure = Mesure::find($id);
 
        $mesure->nom = $request->nom;
        $mesure->gps = $request->gps;
        $mesure->save();

        return Redirect::to('/mesures');
    }
 
    public function show($id)
    {
        $user = Auth::user($id);
        if(!$user) return Redirect::route( 'login' );

        $mesure = Mesure::find($id);

        return View::make('mesures.show', 
            [ 
                'user' => $user,'menu' => $this->menu,
                'mesure' => $mesure,
            ]);
    }

    public function destroy($id)
    {

        
        Mesure::destroy($id);
 
        return Redirect::to('/mesures');
    }
 

}



