<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Role2;
use App\Ruche;
//use App\Parametre;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use View;
use App\Http\Requests\RucheRequest;

class RuchesController extends Controller {
 
    private $menu='ruches';

    public function __construct()
    {
        //$this->beforeFilter('auth');
    }
 
    public function index()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

       $ruches=Ruche::all();

        return View::make('ruches.index', [
            'user'=>$user,'menu' => $this->menu,
            'ruches' => $ruches, 
            
            
        ]);
    }
 
    public function create()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        return View::make('ruches.create',
            [
                'user' => $user,'menu' => $this->menu
            ]);

    }
 
    public function store(RucheRequest $request)
    {
        $ruche = new Ruche;
 
        $ruche->nom = $request->nom;
        $ruche->gps = $request->gps;
        $ruche->mac = $request->mac;
        $ruche->save();

        return Redirect::to('/ruches');
    }
 
    public function edit($id)
    {
        $user = Auth::user($id);
        if(!$user) return Redirect::route( 'login' );

        $ruche = Ruche::find($id);

        return View::make('ruches.edit', 
            [ 
                'user' => $user,'menu' => $this->menu,
                'ruche' => $ruche,
            ]);
    }
 

    public function update($id,RucheRequest $request)
    {
        $ruche = Ruche::find($id);
 
        $ruche->nom = $request->nom;
        $ruche->gps = $request->gps;
        $ruche->mac = $request->mac;
        $ruche->save();

        return Redirect::to('/ruches');
    }
 
    public function show($id)
    {
        $user = Auth::user($id);
        if(!$user) return Redirect::route( 'login' );

        $ruche = Ruche::find($id);

        return View::make('ruches.show', 
            [ 
                'user' => $user,'menu' => $this->menu,
                'ruche' => $ruche,
            ]);
    }

    public function destroy($id)
    {

        
        Ruche::destroy($id);
 
        return Redirect::to('/ruches');
    }
 

}



