<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Role2;
use App\TypeCapteur;
//use App\Parametre;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use View;
use App\Http\Requests\TypeCapteurRequest;

class TypesCapteursController extends Controller {
 
    private $menu='types_capteurs';

    public function __construct()
    {
        //$this->beforeFilter('auth');
    }
 
    public function index()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

       $types_capteurs=TypeCapteur::all();

        return View::make('types_capteurs.index', [
            'user'=>$user,'menu' => $this->menu,
            'types_capteurs' => $types_capteurs, 
            
            
        ]);
    }
 
    public function create()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        return View::make('types_capteurs.create',
            [
                'user' => $user,'menu' => $this->menu
            ]);

    }
 
    public function store(TypeCapteurRequest $request)
    {
        $type_capteur = new TypeCapteur;
 
        $type_capteur->nom = $request->nom;
        $type_capteur->unite = $request->unite;
        $type_capteur->save();

        return Redirect::to('/types_capteurs');
    }
 
    public function edit($id)
    {
        $user = Auth::user($id);
        if(!$user) return Redirect::route( 'login' );

        $type_capteur = TypeCapteur::find($id);

        return View::make('types_capteurs.edit', 
            [ 
                'user' => $user,'menu' => $this->menu,
                'type_capteur' => $type_capteur,
            ]);
    }
 

    public function update($id,TypeCapteurRequest $request)
    {
        $type_capteur = TypeCapteur::find($id);
 
        $type_capteur->nom = $request->nom;
        $type_capteur->unite = $request->unite;
        $type_capteur->save();

        return Redirect::to('/types_capteurs');
    }
 
    public function show($id)
    {
        $user = Auth::user($id);
        if(!$user) return Redirect::route( 'login' );

        $type_capteur = TypeCapteur::find($id);

        return View::make('types_capteurs.show', 
            [ 
                'user' => $user,'menu' => $this->menu,
                'type_capteur' => $type_capteur,
            ]);
    }

    public function destroy($id)
    {

        
        TypeCapteur::destroy($id);
 
        return Redirect::to('/types_capteurs');
    }
 

}



