<?php namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Authenticatable;


class Ruche extends Model {
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'ruches';

	public function getNbCapteursAttribute() {
		$nb=Capteur::where('id_ruche','=',$this->id)->count();

		return $nb;
	}
	
	public function getNbMesuresAttribute() {
		$nb=Mesure::join('capteurs','capteurs.id','=','mesures.id_capteur')
			->where('capteurs.id_ruche','=',$this->id)->count();

		return $nb;
	}

	public function getPoidsActuelAttribute() {
		$type_capteur=TypeCapteur::where('nom','=',"Masse")->first();
		$capteur=Capteur::where('id_type_capteur','=',$type_capteur->id)
			->where('id_ruche','=',$this->id,)->first();
		if(!$capteur) return "";
		$mesure=Mesure::where('id_capteur','=',$capteur->id)->orderby('date','DESC')->first();
		if(!$mesure) return "";
		return $mesure->value;
	}

	public function getLastMesureAttribute() {
		$capteur=Capteur::where('id_ruche','=',$this->id,)->first();
		if(!$capteur) return "";
		$mesure=Mesure::where('id_capteur','=',$capteur->id)->orderby('date','DESC')->first();
		if(!$mesure) return "";
		return $mesure->date;
	}
}