@extends('layouts.dash')
{!! $with_navbar=false !!}
@section('title') Rôle @stop
@section('title_card',"Consultation du Rôle")
@section('content')
<div class="card">
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="col-lg-max col-lg-offset-1 container-fluid">
        {!! Form::model($role, ['class' => 'form-horizontal']) !!}
            <div class="form-group row">
                <div class="col-md-6">
                {!! Form::label('name', 'Nom') !!}
                {!! Form::text('name', null, ['readonly', 'class' => 'form-control']) !!}
                </div>
            </div>
            <div class="row">
                <div class="col-md-5">
                    <div class="form-group">
                        {!! Form::label('permissions', 'Permissions') !!}
                        {!! Form::select(
                            'role_permissions[]',
                            $liste_premissions,
                            $t_getPermissions,
                            [   'readonly',
                                'class' => 'selectpicker form-control',
                                'multiple'=> 'multiple',
                                'data-selected-text-format'=>"count",
                                'data-width' => "100%"
                            ]
                        ) !!}
                    </div>
                </div>
            </div>
            <div class='form-group'>
                <a class="btn btn-warning"  href="{!! url('roles') !!}">Retour</a>
            </div>
            {!! Form::close() !!}
        </div>
</div>
@endsection