@extends('layouts.dash')
{!! $with_navbar=false !!}
@section('title') Utilisateur @stop
@section('title_card',"Nouvel Utilisateur")
@section('content')
<div class="card">
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="col-lg-max col-lg-offset-1 container-fluid">
          {!! Form::open(['class' => 'form-horizontal', 'url' => '/users']) !!}
            <div class="form-group row">
                <div class="col-md-6">
                {!! Form::label('name', 'Nom') !!}
                {!! Form::text('name', null, ['placeholder' => 'Nom', 'class' => 'form-control text-uppercase']) !!}
                </div>
            </div>
            <div class="form-group row">
                <div class="col-md-6">
                {!! Form::label('email', 'Email') !!}
                {!! Form::email('email', null, ['placeholder' => 'Email', 'class' => 'form-control text-lowercase']) !!}
                </div>
            </div>
            <div class="form-group row">
                <div class="col-md-4">
                {!! Form::label('password', 'Mot de passe') !!}
                {!! Form::password('password', ['placeholder' => 'Mot de passe'
                    , 'class' => 'form-control']) !!}
                </div>
            </div>
            <div class='form-group'>
                    {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
                    <a class="btn btn-warning"  href="{!! url('users') !!}">Retour</a>
            </div>
        {!! Form::close() !!}
    </div>
</div>
@endsection