@extends('layouts.dash')
{!! $with_navbar=false !!}
@section('title') Capteurs @stop
@section('title_card',"Mise à jour d'un Capteur")
@section('content')
<div class="card">
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="col-lg-max col-lg-offset-1 container-fluid">
        {!! Form::model($capteur, ['capteur' => 'form', 'url' => '/capteurs/' . $capteur->id, 'method' => 'PUT']) !!}
         

            <div class="form-group row">
                <div class="col-md-6">
                {!! Form::label('nom', 'Nom') !!}
                {!! Form::text('nom', null, ['placeholder' => 'Nom', 'class' => 'form-control']) !!}
                </div>
            </div>
         
            <div class="form-group row">
                <div class="col-md-6">
                {!! Form::label('id_ruche', 'Ruche') !!}
                {!! Form::select('id_ruche', $liste_ruches,null,['placeholder' => 'A definir','class' => 'form-control']) !!}
                </div>
            </div>

            <div class="form-group row">
                <div class="col-md-6">
                {!! Form::label('id_type_capteur', 'Type de capteur') !!}
                {!! Form::select('id_type_capteur', $liste_types_capteurs,null,['placeholder' => 'A definir','class' => 'form-control']) !!}
                </div>
            </div>

            <div class="form-group row">
                <div class="col-md-3">
                {!! Form::label('alerte_bas', "Niveau d'alerte bas") !!}
                {!! Form::text('alerte_bas', null, ['placeholder' => 'valeur', 'class' => 'form-control']) !!}
                </div>
                <div class="col-md-3">
                {!! Form::label('alerte_haut', "Niveau d'alerte haut") !!}
                {!! Form::text('alerte_haut', null, ['placeholder' => 'valeur', 'class' => 'form-control']) !!}
                </div>
            </div>

        {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
        <a class="btn btn-warning"  href="{!! url('capteurs') !!}">Retour</a>
    </div>
    {!! Form::close() !!}
</div>
@endsection