@extends('layouts.dash_guest_api')
@section('title') Ruche Connectée @stop
@section('title_card',"BTS-SN - La Ruche Connectée")
@section('content')

<div class="row">
    <!-- GRAPH Masse-->
    <div class="col-md-4">
        <div class="card card-primary ">
            <div class="card-header">
                Masse
                <div class="card-tools">
                    <button type="button" class="btn bg-primary btn-sm" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn bg-primary btn-sm" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="position-relative mb-4">
                    <canvas id="masse-chart" style="display: block; height: 330px; width: 528px;" class="chartjs-render-monitor"></canvas>
                </div>
            </div> 
        </div>      
    </div> 

    <!-- Graph Température -->
    <div class="col-md-4">
        <div class="card card-info">
            <div class="card-header">
                Températures 
                <div class="card-tools">
                    <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn bg-info btn-sm" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="position-relative mb-4">
                    <canvas id="temp-chart" style="display: block; height: 330px; width: 528px;" class="chartjs-render-monitor"></canvas>
                </div>
            </div>
        </div> 
    </div>

    <!-- Data -->
    <div class="col-md-4">
        <div class="card card-success">
            <div class="card-header">
                Données Masse/Temperature
                <div class="card-tools">
                    <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn bg-info btn-sm" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <table id="_table" class="table table-condensed table-striped table-hover table-bordered">
                    <thead>
                        <tr>
                            <th width="1px">Date</th>
                            <th>Masse (kg)</th>
                            <th>Temperature (°C)</th>
                            <th>Toit</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($t_data_all as $key=>$t_data)
                        @php
                            $date=$key;
                            $temperature=isset($t_data["Temperature"])?$t_data["Temperature"]:"";
                            $masse=isset($t_data["Masse"])?$t_data["Masse"]:"";
                            $ils="";
                            if($t_data["ILS"]) $ils="<span class='right badge badge-danger'>OPEN</span>";

                        @endphp
                            <tr>
                                <td nowrap align="left">{!! $key !!}</td>
                                <td nowrap align="center">{!! $masse !!}</td>
                                <td nowrap align="center">{!! $temperature !!}</td>
                                <td nowrap align="center">{!! $ils !!}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

            </div>
        </div> 
    </div>
</div>


<div class="row">
    <!-- GRAPH Humidité-->
    <div class="col-md-4">
        <div class="card card-primary ">
            <div class="card-header">
                Humidité
                <div class="card-tools">
                    <button type="button" class="btn bg-primary btn-sm" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn bg-primary btn-sm" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="position-relative mb-4">
                    <canvas id="humidite-chart" style="display: block; height: 330px; width: 528px;" class="chartjs-render-monitor"></canvas>
                </div>
            </div> 
        </div>      
    </div> 

    <!-- Graph Pression -->
    <div class="col-md-4">
        <div class="card card-info">
            <div class="card-header">
                Pression 
                <div class="card-tools">
                    <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn bg-info btn-sm" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="position-relative mb-4">
                    <canvas id="pression-chart" style="display: block; height: 330px; width: 528px;" class="chartjs-render-monitor"></canvas>
                </div>
            </div>
        </div> 
    </div>

    <!-- Data -->
    <div class="col-md-4">
        <div class="card card-success">
            <div class="card-header">
                Données Pression/Humidité
                <div class="card-tools">
                    <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn bg-info btn-sm" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <table id="_table2" class="table table-condensed table-striped table-hover table-bordered">
                    <thead>
                        <tr>
                            <th width="1px">Date</th>
                            <th>Pression (hPa)</th>
                            <th>Humidité (%)</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($t_data_all as $key=>$t_data)
                        @php
                            $date=$key;
                            $pression=isset($t_data["Pression"])?$t_data["Pression"]:"";
                            $humidite=isset($t_data["Humidité"])?$t_data["Humidité"]:"";
                            $ils="";
                            if($t_data["ILS"]) $ils="<span class='right badge badge-danger'>OPEN</span>";

                        @endphp
                            <tr>
                                <td nowrap align="left">{!! $key !!}</td>
                                <td nowrap align="center">{!! $pression !!}</td>
                                <td nowrap align="center">{!! $humidite !!}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div> 
    </div>
</div>


<div class="row">
    <!-- GRAPH Tension-->
    <div class="col-md-4">
        <div class="card card-primary ">
            <div class="card-header">
                Tension
                <div class="card-tools">
                    <button type="button" class="btn bg-primary btn-sm" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn bg-primary btn-sm" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="position-relative mb-4">
                    <canvas id="tension-chart" style="display: block; height: 330px; width: 528px;" class="chartjs-render-monitor"></canvas>
                </div>
            </div> 
        </div>      
    </div> 

    <!-- Graph Luminosité -->
    <div class="col-md-4">
        <div class="card card-info">
            <div class="card-header">
                Luminosité 
                <div class="card-tools">
                    <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn bg-info btn-sm" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="position-relative mb-4">
                    <canvas id="luminosite-chart" style="display: block; height: 330px; width: 528px;" class="chartjs-render-monitor"></canvas>
                </div>
            </div>
        </div> 
    </div>

    <!-- Data -->
    <div class="col-md-4">
        <div class="card card-success">
            <div class="card-header">
                Données Lux/U
                <div class="card-tools">
                    <button type="button" class="btn bg-info btn-sm" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn bg-info btn-sm" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <table id="_table3" class="table table-condensed table-striped table-hover table-bordered">
                    <thead>
                        <tr>
                            <th width="1px">Date</th>
                            <th>Luminosité (Lux)</th>
                            <th>Tension (V)</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($t_data_all as $key=>$t_data)
                        @php
                            $date=$key;
                            $luminosite=isset($t_data["Luminosité"])?$t_data["Luminosité"]:"";
                            $tension=isset($t_data["Tension"])?$t_data["Tension"]:"";
                            $ils="";
                            if($t_data["ILS"]) $ils="<span class='right badge badge-danger'>OPEN</span>";
                        @endphp
                            <tr>
                                <td nowrap align="left">{!! $key !!}</td>
                                <td nowrap align="center">{!! $luminosite !!}</td>
                                <td nowrap align="center">{!! $tension !!}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div> 
    </div>
</div>

@endsection

@section('scripts')

<script>
  $(function () {
    $("#_table").DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": false,
      "info": false,
      "responsive": true, 
      "autoWidth": false,
      "pageLength": 5,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Prec","sNext": "Suiv"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
        },
    })

    $("#_table2").DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": false,
      "info": false,
      "responsive": true, 
      "autoWidth": false,
      "pageLength": 5,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Prec","sNext": "Suiv"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
        },
    })


    $("#_table3").DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": false,
      "info": false,
      "responsive": true, 
      "autoWidth": false,
      "pageLength": 5,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Prec","sNext": "Suiv"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
        },
    })
  });
</script>


<script>
  $(function () {
    'use strict'
    var ticksStyle = {
      fontColor: 'black',
      fontStyle: 'bold'
    }
    var mode = 'index'
    var intersect = true

    
    @include("dashboard.script_graph_temp1")
    @include("dashboard.script_graph_masse1")
    @include("dashboard.script_graph_humidite1")
    @include("dashboard.script_graph_pression1")
    @include("dashboard.script_graph_tension1")
    @include("dashboard.script_graph_luminosite1")
  })
</script>
@endsection
