@extends('layouts.dash')

@section('content')

   <section class="content">
        <div class="container-fluid">
            
            <!-- Small boxes (Stat box) -->
            <div class="row">
                <div class="col-lg-2">
                    <!-- small box -->
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3>{!! $t_indicateurs["nb_ruches"]!!}</h3>
                            <p>Ruches</p>
                        </div>
                        <div class="icon">
                            <i class="fa fa-group"></i>
                        </div>
                        <a href="{!! url('ruches') !!}" class="small-box-footer">Détail <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>

              <!-- ./col -->
                <div class="col-lg-2">
                    <!-- small box -->
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3>{!! $t_indicateurs["nb_alertes"]!!}</h3>
                            <p>Alertes</p>
                        </div>
                        <div class="icon">
                            <i class="fa fa-bookmark"></i>
                        </div>
                        <a href="{!! url('alertes') !!}" class="small-box-footer">Détail <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>

                <!-- ./col -->
                <div class="col-lg-2">
                    <!-- small box -->
                    <div class="small-box bg-red">
                        <div class="inner">
                            <h3>{!! $t_indicateurs["nb_mesures"] !!}</h3>
                            <p>Mesures</p>
                        </div>
                        <div class="icon">
                            <i class="fa fa-terminal"></i>
                        </div>
                        <a href="{!! url('mesures') !!}" class="small-box-footer">Détail <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>

                <!-- ./col -->
                <div class="col-lg-2">
                    <!-- small box -->
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3>{!! $t_indicateurs["nb_receptions"] !!}</h3>
                            <p>Mesures</p>
                        </div>
                        <div class="icon">
                            <i class="nav-icon fas fa-chart-line"></i>
                        </div>
                        <a href="{!! url('receptions') !!}" class="small-box-footer">Détail <i class="fa fa-arrow-circle-right"></i></a>
                    </div>
                </div>


                <!-- ./col -->
                <div class="col-lg-1">
                    <!-- small box -->
                    <div class="">
                        <div class="inner">
                            {!! QrCode::size(90)->generate("https://ruches.btssn.nc"); !!}
                        </div>
                    </div>
                </div>

              <!-- ./col -->
            </div>
            <!-- /.row -->
            <!-- Main row -->
            <div class="card">
                <div class="card-body">

                        <table id="_table" width="100%" class="table table-striped table-bordered">
                            <thead>
                                <tr role="row">
                                    <th style='text-align:center;' >Id</th>
                                    <th style='text-align:center;' >Nom</th>
                                    <th style='text-align:center;' >Email</th>
                                    <th style='text-align:center;' >Rôles</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($users as $user_enc)
                                <tr>
                                    <td>{!! $user_enc->id !!}</td>
                                    <td>{!! $user_enc->name   !!}</td>
                                    <td>{!! $user_enc->email  !!}</td>
                                    <td>{!! $user_enc->getRoleNames()->first() !!}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>

                </div>
            </div>
        <!-- /.row (main row) -->
        </div><!-- /.container-fluid -->
    </section>
@endsection

@section('scripts')
@include("forms.scripts_datatable")
@endsection
