@extends('layouts.dash')

@section('title') Mesures @stop
@section('title_card',"Mesures")
@section('subtitle_card',"Graphiques")
@section('content')
    <div class="card">

        <div class="row">
          <div class="col-md-2">
             {!! Form::open(['role' => 'form', 'url' => '/mesures_filtre']) !!}
                {!! Form::label('select_ruche', 'Ruche') !!}
                {!! Form::select('select_ruche[]', $liste_ruches,$t_id_ruche,
                  [
                    'id'=>'select_ruche',
                    'class' => 'selectpicker form-control','data-width'=>'100%','multiple'=> 'multiple']) !!}
                </div>
                <div class="col-md-2">
                {!! Form::label('select_type_capteur', 'Capteur') !!}
                {!! Form::select('select_type_capteur', $liste_type_capteur,$type_capteur->id,['id'=>'select_type_capteur','placeholder' => 'A definir','class' => 'form-control','data-width'=>'100%']) !!}
                </div>
                <div class="col-md-2" style="padding-top:30px">
                  <input type="button" class="btn btn-info" value="Valider" onclick="submit()"/>
                </div>
            {!! Form::close() !!}
        </div>
        <br/>
        <div class="row">
            @include("mesures.graph")           
        </div>
    </div>
@endsection


@section('scripts')
  <script>
    @include("mesures.script_tables")

  </script>


<script>
  $(function () {
    'use strict'
    var ticksStyle = {
      fontColor: 'black',
      fontStyle: 'bold'
    }
    var mode = 'index'
    var intersect = true

    @include("mesures.script_graph")

  })
</script>


   

@endsection

