@extends('layouts.dash')

@section('title') Mesures @stop
@section('title_card',"Mesures")
@section('subtitle_card',"Liste complète")
@section('content')
    <div class="card">

        <div class="row">
          <div class="col-md-2">
          {!! Form::label('select_ruche', 'Ruche') !!}
          {!! Form::select('select_ruche', $liste_ruches,null,['id'=>'select_ruche','placeholder' => 'A definir','class' => 'form-control','data-width'=>'100%']) !!}
          </div>
          <div class="col-md-2">
          {!! Form::label('select_capteur', 'Capteur') !!}
          {!! Form::select('select_capteur', $liste_capteur,null,['id'=>'select_capteur','placeholder' => 'A definir','class' => 'form-control','data-width'=>'100%']) !!}
          </div>
          <div class="col-md-2" style="padding-top:30px">
            <input type="button" class="btn btn-info" value="Valider" onclick="valider()"/>
          </div>

          <script>
            function valider() {
              var obj  = document.getElementById('select_ruche');
              var id_ruche=obj.options[obj.selectedIndex].value;
              var obj  = document.getElementById('select_capteur');
              var id_capteur=obj.options[obj.selectedIndex].value;

              document.location.href="{!! url('mesures_filtre') !!}"+"/"+"id_ruche="+id_ruche+"/"+"id_capteur="+id_capteur;
            }

          </script>
        </div>
        <br/>
        <div class="row">
            @include("mesures.graph_temperature")
            @include("mesures.graph_humidite")
            @include("mesures.graph_pression")
           
        </div>
    </div>
@endsection


@section('scripts')
  <script>
    @include("mesures.script_tables")

  </script>


<script>
  $(function () {
    'use strict'
    var ticksStyle = {
      fontColor: '#495057',
      fontStyle: 'bold'
    }
    var mode = 'index'
    var intersect = true

    @include("mesures.script_temperature")

    @include("mesures.script_humidite")

    @include("mesures.script_pression")

  })
</script>


   

@endsection

