@extends('layouts.dash')

@section('title') Type de Capteurs @stop
@section('title_card',"Type de Capteurs")
@section('content')
    <div class="card">
        <div class="card-body">
            <table id="_table" width="100%" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th width='7%' >Nom</th>
                        <th width='5%'>Unité</th>
                        <th>Nb Ruche</th>
                        <th>Nb Mesures</th>
                        <th width='75px'>
                            <a href="{!! url('types_capteurs/create') !!}" class="btn btn-success">
                                <span class='ti-plus'></span></a> 
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($types_capteurs as $type_capteur)
                    <tr>
                        <td nowrap>
                            <a href="{!! url('types_capteurs/'.$type_capteur->id) !!}" >{!! $type_capteur->nom !!}</a>
                        </td>
                        <td align="center">{!! $type_capteur->unite !!}</td>
                        <td nowrap>{!! $type_capteur->NbRuche !!}</td>
                        <td nowrap>{!! $type_capteur->NbMesures !!}</td>
                        <td nowrap>
                            <a href="./types_capteurs/{!! $type_capteur->id !!}/edit" class="btn btn-info pull-left" style="margin-right: 3px;">
                                <span class='ti-pencil-alt'></span>
                            </a>

                            {!! Form::open(['url' => url('types_capteurs/' . $type_capteur->id), 'method' => 'DELETE']) !!}
                                {{ csrf_field() }}
                                <button class="btn btn-danger">
                                    <span class='ti-trash'></span>
                                </button>
                            {!! Form::close() !!}
                        
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable")
@endsection