<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Role2;
use App\Models\Permission2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use App\Http\Requests\RoleRequest;
use Illuminate\Http\Request;
//use Input;


class RolesController extends Controller {

    private $menu='acces';
    private $submenu='roles';
    private $menu_home='acces';


    public function __construct()
    {
        //$this->beforeFilter('auth');
    }


    public function index($mode="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->can("ROL_VISU")&&(!$user->hasRole("ADMINISTRATEUR"))) return;

        $roles = Role2::where('id', '<>', 'null')->where('name','<>','ADMINISTRATEUR')->orderBy('name')->get();

        return View::make('acces.roles.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'roles' => $roles,
        ]);
    }

    public function index_det()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->can("ROL_VISU")&&(!$user->hasRole("ADMINISTRATEUR"))) return;

        $roles = Role2::where('id', '<>', 'null')->where('name','<>','ADMINISTRATEUR')->orderBy('name')->get();
        return View::make('acces.roles.index_ltd', ['roles' => $roles, 'user'=>$user]);
    }



    public function create($mode="create",$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if($mode=="create") if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ROL_AJO")) return redirect('home');
        if($mode=="edit") if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ROL_MAJ")) return redirect('home');
        if($mode=="show") if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ROL_VISU")) return redirect('home');

        $role = Role2::find($id);
        $liste_permissions=Permission2::orderby('name')->pluck("name","id")->toArray();
        $t_getPermissions=[];
        if($id) {
            $t_getPermissions=DB::table('role_has_permissions')
                ->where('role_id', '=', $id)
                ->pluck("permission_id")
                ->toArray();
        }
        
        return View::make('acces.roles.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,'mode' => $mode,
            'role' => $role ,
            't_getPermissions' => $t_getPermissions,
            'liste_permissions' => $liste_permissions, 
            ]);
    }

    public function store(RoleRequest $request)
    {
        $role = $this->setData($request);
        return Redirect::to('/roles');
    }

    public function edit($id)
    {
        return $this->create("edit",$id);
    }

    public function update($id,RoleRequest $request)
    {
        $role = $this->setData($request,$id);
        return Redirect::to('/roles');
    }

    public function show($id)
    {
        return $this->create("show",$id);
    }

    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if(!$id) $role = new Role2;
        else $role = Role2::find($id);

        $role->name = strtoupper($request->name);
        $role->save();

        //Détache les anciennes permissions
        DB::table('role_has_permissions')->where('role_id', '=', $role->id)->delete();
        if(isset($request->role_permissions)) {
            $t_role_permissions = $request->role_permissions;
            if(count($t_role_permissions)>0) {
                //Attache les nouveaux
                foreach($t_role_permissions as $permission_id) {
                    $permission = Permission2::find($permission_id);
                    $role->givePermissionTo($permission );
                }
            }
        }
        return $role;
    }


    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $role=Role2::find($id);
        Role2::destroy($id);
        return Redirect::to('/roles');
    }


    public function newprofil()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if((!$user->hasRole("ADMINISTRATEUR")) &&(!$user->hasRole("ADMINISTRATEUR FONCTIONNEL")))  return redirect('home');

        $users_list=array();
        $res_list=array();
        $origine_user_id=User::where('id','=',Session::get('origine_id'))->first();
        if($origine_user_id->HasRole("ADMINISTRATEUR")
            || $origine_user_id->hasRole("ADMINISTRATEUR FONCTIONNEL")) {
            //$assigned_roles = DB::table('assigned_roles')->where('user_id','=',$user->id)->get();
            $users_list=DB::table('users')->orderby(db::raw("CONCAT(nom,' ',prenom)"))
                ->pluck(db::raw("CONCAT(nom,' ',prenom) as nom"), 'id')->toArray();
            foreach($users_list as $id=>$nom) {
                $user_enc=User::find($id);
                if(!$user_enc->hasrole('ADMINISTRATEUR') && ($origine_user_id->id!=$id)
                    || (!$user_enc->Sysadmin) ) {
                    $res_list[$id]=$nom;
                }
            }
            return View::make('param.actions.index', ['users_list' => $res_list,'user' => $user]);
        }
        return;
    }



    public function origine_profil()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if((!$user->hasRole("ADMINISTRATEUR")) &&(!$user->hasRole("ADMINISTRATEUR FONCTIONNEL")))  return redirect('home');

        $origine_user_id=User::where('id','=',Session::get('origine_id'))->first();
        if($origine_user_id->hasRole("ADMINISTRATEUR") || $origine_user_id->hasRole("ADMINISTRATEUR FONCTIONNEL")) {
            $user = User::find($origine_user_id->id);
            Session::put('id', $user->id);
            return Redirect::to('/accueil');
        }
       return ;
    }


    public function changeprofil(Request $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if((!$user->hasRole("ADMINISTRATEUR")) &&(!$user->hasRole("ADMINISTRATEUR FONCTIONNEL")))  return redirect('home');

        if($mode="create") if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ROL_AJO")) return redirect('home');

        $origine_user_id=User::where('id','=',Session::get('origine_id'))->first();
        if($origine_user_id->hasRole("ADMINISTRATEUR") || $origine_user_id->hasRole("ADMINISTRATEUR FONCTIONNEL")) {
            //Attach Protocole
            $user_id = $request->user_id;
            if($user_id>0) {
                $user = User::find($user_id);
                Session::put('id', $user->id);
                return Redirect::to('/accueil');
            }
        }
       return ;
    }
}


