<div class="form-group row">
    <div class="col-md-6">
        {!! html()->label( 'Nom','name') !!}
        {!! html()->text('name', null)->attributes(['placeholder' => 'Nom','class' => 'form-control text-uppercase']) !!}
    </div>
</div>

       
<h3>Permissions</h3>
<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            {!! html()->label( "Permissions",'permissions') !!}
            <select name="role_permissions[]" class="select2" multiple="multiple" data-placeholder="Aucune" style="width: 100%;" {{ ($mode=="show"?'disabled':'') }} >
                @foreach($liste_permissions as $id=>$nom)
                    <option
                        {!! (in_array($id, $t_getPermissions)?"selected":"") !!}
                        value="{!! $id !!}">{!! $nom !!}
                    </option>
                @endforeach
            </select>
        </div>
    </div>
</div>


<div class='form-group'>
    <div class="col-md-12">
        @if(($mode=="show") && ($user->hasRole("ADMINISTRATEUR") || $user->can("ROL_MAJ"))) 
           <a class="btn btn-primary" href="{!! url('roles/'.$role->id.'/edit') !!}" id="btn_modifier">Modifier</a>
        @else
            {!! html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
        @endif
        &nbsp;<a class="btn btn-warning"  href="{!! url('roles/') !!}">Retour</a>
        @if(($mode=="show") && ($user->hasRole("ADMINISTRATEUR") || $user->can("ROL_SUP"))) 
            {{ html()->form('DELETE', url('/roles/'. $role->id))->open() }}
            </br><button class="btn btn-danger" onclick="if(!confirm('Voulez-vous vraiment supprimer ce rôle ?')) return false;">Supprimer</button>
            {{ html()->form()->close() }}
        @endif
    </div>
</div>
