@extends('layouts.dash')
@section('title') Rôles @stop
@section('title_card')  @stop

@section('content')
    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-md-5">
                    <label>Groupe de permission</label>
                    {!! html()->select('id_groupe')->options($liste_groupes)
                        ->value((isset($id_groupe)?$id_groupe:''))
                        ->placeholder('Choisissez un groupe de permission')
                        ->attributes(['class' => 'form-control','id' => 'id_groupe','onchange'=>'select_filtre()'])  !!}

                </div>

                <script>
                    function select_filtre() {
                        var select_id_groupe = document.getElementById('id_groupe');
                        var selected_id_groupe = [...select_id_groupe.selectedOptions].map(option => option.value);
                        var url="" ;
                        if(selected_id_groupe=="") selected_id_groupe=0;
                        url="{!! url('role_tableau_filtre/') !!}/"+selected_id_groupe;
                        location.href=url;
                    }
                </script>

            </div>
        </div>
        <div class="card-body">
            <table id="_table" width="100%" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th width='10%'>Permissions</th>
                        @foreach ($roles as $role)
                            <th>{!! $role->name !!}</th>
                        @endforeach
                    </tr>
                </thead>

                <tbody>
                    @foreach ($permissions as $permission)
                        <tr>
                            <td>{!! $permission->display_name !!}</td>
                            @foreach ($roles as $role)
                            <td align='center' style="{!! $role->hasPermissionTo($permission->name)?'background-color:lightgreen':'' !!}">

                                @if($role->hasPermissionTo($permission->name))
                                    {!! "OUI" !!}
                                @else
                                    {!! "-" !!}
                                @endif
                            </td>
                            @endforeach
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection


@section('scripts')
<script>
  $(function () {
    $("#_table").DataTable({
      "paging": false,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "responsive": false,
      "autoWidth": false,
      "fixedHeader": true,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }

        },
        dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",

        "buttons": ["copy", "excel", "colvis"] //"print", "pdf", "csv",
    })
    .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

  });
</script>

@endsection


