<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>BTSCIEL-2025</title>
        <link rel="shortcut icon" href="<?php echo url('/img/logo.ico'); ?>">
        

        <!-- Styles -->
        <style>
            html, body {
                /*background-image:url("https://th.bing.com/th/id/OIP.vta3Rz7V06XTjQw4EzkpNwHaE9?pid=ImgDet&rs=1");*/
                background-size: cover;
                color: #AAA;
                font-family: 'math', sans-serif;
               
            }

            .full-height {
                height: 100vh;
            }

            .flex-center {
                align-items: center;
                display: flex;
                justify-content: center;
            }

            .position-ref {
                position: relative;
            }

            .top-right {
                position: absolute;
                right: 10px;
                top: 18px;
            }

            .content {
                text-align: center;
            }

            .title {
                font-size: 84px;
            }

            .subtitle {
                font-size: 44px;
            }

            .subtitle2 {
                font-size: 22px;
            }

            .links > a {
                color: black;
                padding: 0 25px;
                font-size: 13px;
                font-weight: 600;
                letter-spacing: .1rem;
                text-decoration: none;
                text-transform: uppercase;
            }

            .m-b-md {
                margin-bottom: 30px;
            }
        </style>
    </head>
    <body>
        <div class="flex-center position-ref full-height">
            <?php if(Route::has('login')): ?>
                <div class="top-right links">
                    <?php if(auth()->guard()->check()): ?>
                        <a href="<?php echo e(url('/home')); ?>">Accueil</a>
                    <?php else: ?>
                        <a href="<?php echo e(route('login')); ?>">Se connecter</a>

                        <?php if(Route::has('register')&&(0==1)): ?>
                            <a href="<?php echo e(route('register')); ?>">S'enregistrer</a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <div class="content">
                <img src="<?php echo url('/img/logo.png'); ?>" alt="Logo" class="brand-image elevation-1" style="opacity: 1">
                <div class="title m-b-md">
                    BTSCIEL-2025
                </div>
                <div class="subtitle m-b-md">
                    Lycée du Mont-Dore
                </div>
            </div>
        </div>
    </body>
</html>
<?php /**PATH /var/www/html/laravel12btsciel/resources/views/welcome.blade.php ENDPATH**/ ?>