<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\AlertEngine;

class AlertScanController extends Controller
{
    public function scan(Request $request)
    {
        $this->middleware('auth'); // par sécurité

        $ref   = $request->input('ref');   // optionnel
        $hours = (int)($request->input('hours', 24));

        $res = AlertEngine::scan($ref, $hours);

        if ($request->wantsJson()) {
            return response()->json([
                'ok'=>true,
                'result'=>$res
            ]);
        }

        return back()->with('status', "Scan alertes OK — scannés {$res['scanned']}, créées {$res['created']}, auto-ack {$res['auto_acked']}.");
    }
}
