<?php
namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;
use App\Models\Mesure;
use App\Models\Ruche;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
class MesureController extends Controller
{
    public function store(Request $request, Ruche $ruche)
    {
        $v = Validator::make($request->all(), [
            'date_heure'      => ['required','date'],
            'poids'           => ['nullable','numeric'],
            'temperature_int' => ['nullable','numeric'],
            'temperature_ext' => ['nullable','numeric'],
            'humidite_int'    => ['nullable','numeric'],
            'humidite_ext'    => ['nullable','numeric'],
            'batterie'        => ['nullable','numeric'],
        ]);
        if ($v->fails()) { return response()->json(['errors'=>$v->errors()], 422); }
        $data = $v->validated();
        $m = Mesure::create([
            'ruche_id'        => $ruche->id,
            'date_heure'      => $data['date_heure'],
            'poids'           => $data['poids'] ?? null,
            'temperature_int' => $data['temperature_int'] ?? null,
            'temperature_ext' => $data['temperature_ext'] ?? null,
            'humidite_int'    => $data['humidite_int'] ?? null,
            'humidite_ext'    => $data['humidite_ext'] ?? null,
            'batterie'        => $data['batterie'] ?? null,
            'payload'         => $request->all(),
        ]);
        return response()->json(['ok'=>true, 'id'=>$m->id], 201);
    }
}
