<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Models\Rucher;
use Illuminate\Http\Request;

class RucherController extends Controller
{
    public function index()
    {
        $ruchers = Rucher::withCount('ruches')->orderBy('nom')->paginate(15);
        return view('ruchers.index', compact('ruchers'));
    }

    public function show(Rucher $rucher)
    {
        $rucher->load('apiculteur', 'ruches');
        return view('ruchers.show', compact('rucher'));
    }
}
