<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('ruchers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('apiculteur_id')->nullable()->constrained('apiculteurs')->cascadeOnDelete();
            $table->string('nom', 150);
            $table->string('localisation')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ruchers');
    }
};