<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('ruches', function (Blueprint $table) {
            $table->id();
            $table->foreignId('rucher_id')->constrained('ruchers')->cascadeOnDelete();
            $table->string('reference')->unique();
            $table->string('modele')->nullable();
            $table->timestamps();

            $table->index('rucher_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ruches');
    }
};