<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('mesures', function (Blueprint $table) {
            $table->id();
            $table->foreignId('capteur_id')->constrained('capteurs')->cascadeOnDelete();
            $table->double('valeur');
            $table->timestamp('measured_at')->nullable();
            $table->timestamps();

            $table->index(['capteur_id', 'measured_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('mesures');
    }
};