<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('apiculteurs', function (Blueprint $table) {
            if (!Schema::hasColumn('apiculteurs', 'user_id')) {
                $table->foreignId('user_id')
                      ->nullable()
                      ->after('id')
                      ->constrained('users')
                      ->cascadeOnDelete();
            }
        });
    }

    public function down(): void
    {
        Schema::table('apiculteurs', function (Blueprint $table) {
            if (Schema::hasColumn('apiculteurs', 'user_id')) {
                $table->dropConstrainedForeignId('user_id');
            }
        });
    }
};