<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('apiculteurs', function (Blueprint $table) {
            if (!Schema::hasColumn('apiculteurs', 'prenom')) {
                $table->string('prenom', 150)->nullable()->after('nom');
            }
        });
    }

    public function down(): void
    {
        Schema::table('apiculteurs', function (Blueprint $table) {
            if (Schema::hasColumn('apiculteurs', 'prenom')) {
                $table->dropColumn('prenom');
            }
        });
    }
};