<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    public function up(): void {
        DB::unprepared(<<<SQL
DROP VIEW IF EXISTS v_last_mesure_by_capteur;
CREATE VIEW v_last_mesure_by_capteur AS
SELECT m1.*
FROM mesures m1
JOIN (
    SELECT capteur_id, MAX(measured_at) AS max_measured_at
    FROM mesures
    GROUP BY capteur_id
) last ON last.capteur_id = m1.capteur_id
     AND last.max_measured_at = m1.measured_at;
SQL);
    }

    public function down(): void {
        DB::unprepared('DROP VIEW IF EXISTS v_last_mesure_by_capteur;');
    }
};
