<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        if (Schema::hasTable('mesures') && !Schema::hasColumn('mesures', 'value_numeric')) {
            Schema::table('mesures', function (Blueprint $table) {
                $table->decimal('value_numeric', 10, 3)->nullable()->after('capteur_id');
            });
        }
    }

    public function down(): void {
        if (Schema::hasTable('mesures') && Schema::hasColumn('mesures', 'value_numeric')) {
            Schema::table('mesures', function (Blueprint $table) {
                $table->dropColumn('value_numeric');
            });
        }
    }
};
