@extends('layouts.app_sidebar')

@section('title','Dashboard')
@section('content')
<div class="row g-3">
  <div class="col-12">
    <div class="p-4 bg-white border rounded-3 card-honey">
      <h1 class="h4 mb-1">Bienvenue 👋</h1>
      <p class="text-muted mb-0">Aperçu rapide des ruches et capteurs, avec courbes en direct.</p>
    </div>
  </div>

  <div class="col-6 col-md-3">
    <div class="p-3 bg-white border rounded-3 card-honey">
      <div class="text-muted">Apiculteurs</div>
      <div class="fs-3 fw-bold">{{ $stats['apiculteurs'] }}</div>
    </div>
  </div>
  <div class="col-6 col-md-3">
    <div class="p-3 bg-white border rounded-3 card-honey">
      <div class="text-muted">Ruchers</div>
      <div class="fs-3 fw-bold">{{ $stats['ruchers'] }}</div>
    </div>
  </div>
  <div class="col-6 col-md-3">
    <div class="p-3 bg-white border rounded-3 card-honey">
      <div class="text-muted">Ruches</div>
      <div class="fs-3 fw-bold">{{ $stats['ruches'] }}</div>
    </div>
  </div>
  <div class="col-6 col-md-3">
    <div class="p-3 bg-white border rounded-3 card-honey">
      <div class="text-muted">Capteurs</div>
      <div class="fs-3 fw-bold">{{ $stats['capteurs'] }}</div>
    </div>
  </div>

  <div class="col-12">
    <div class="p-3 bg-white border rounded-3 card-honey">
      <div class="d-flex align-items-center justify-content-between">
        <h2 class="h5 mb-0">Courbe temps réel</h2>
        <div class="d-flex gap-2">
          <select id="rucheSelect" class="form-select form-select-sm">
            @foreach($ruches as $r)
              <option value="{{ $r->id }}" data-ref="{{ $r->reference }}">{{ $r->reference ?? ('Ruche #' . $r->id) }}</option>
            @endforeach
          </select>
          <select id="typeSelect" class="form-select form-select-sm">
            <option value="temperature">Température (°C)</option>
            <option value="humidity">Humidité (%)</option>
          </select>
        </div>
      </div>
      <canvas id="chart" height="90"></canvas>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script>
const ctx = document.getElementById('chart');
let chart;
async function loadSeries(rucheId, type) {
  const url = `/ruches/${rucheId}/timeseries?type=${encodeURIComponent(type)}&limit=100`;
  const res = await fetch(url);
  const json = await res.json();
  const labels = json.data.map(p => new Date(p.t));
  const values = json.data.map(p => Number(p.val));
  if (chart) chart.destroy();
  chart = new Chart(ctx, {
    type: 'line',
    data: { labels, datasets: [{ label: `${json.reference} — ${type}`, data: values, tension: 0.25 }] },
    options: { responsive: true, scales: { x: { type: 'time', time: { unit: 'minute' } } } }
  });
}

const rucheSelect = document.getElementById('rucheSelect');
const typeSelect  = document.getElementById('typeSelect');
rucheSelect.addEventListener('change', () => loadSeries(rucheSelect.value, typeSelect.value));
typeSelect.addEventListener('change', () => loadSeries(rucheSelect.value, typeSelect.value));
if (rucheSelect && rucheSelect.value) loadSeries(rucheSelect.value, typeSelect.value);
</script>
@endpush