@php
  $user = auth()->user();
@endphp

<nav class="border-b bg-white">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex justify-between h-16">
      <div class="flex">
        <!-- Logo / Home -->
        <div class="shrink-0 flex items-center">
          <a href="{{ url('/') }}" class="font-semibold">Projet Ruche</a>
        </div>
      </div>

      <!-- Right Side -->
      <div class="hidden sm:flex sm:items-center sm:ms-6">
        @auth
          <!-- Settings Dropdown -->
          <x-dropdown align="right" width="48">
              <x-slot name="trigger">
                  <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md focus:outline-none transition">
                      <div>{{ $user->name }}</div>
                      <div class="ms-1">
                          <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                              <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
                          </svg>
                      </div>
                  </button>
              </x-slot>

              <x-slot name="content">
                  <x-dropdown-link :href="route('dashboard')">
                      {{ __('Dashboard') }}
                  </x-dropdown-link>

                  <!-- Authentication -->
                  <form method="POST" action="{{ route('logout') }}">
                      @csrf
                      <x-dropdown-link :href="route('logout')"
                              onclick="event.preventDefault(); this.closest('form').submit();">
                          {{ __('Se déconnecter') }}
                      </x-dropdown-link>
                  </form>
              </x-slot>
          </x-dropdown>
        @endauth

        @guest
          <a href="{{ route('login') }}" class="px-3 py-2 text-sm font-medium hover:underline">Se connecter</a>
          @if (Route::has('register'))
            <a href="{{ route('register') }}" class="px-3 py-2 text-sm font-medium hover:underline">Créer un compte</a>
          @endif
        @endguest
      </div>
    </div>
  </div>
</nav>
