@php
  $items = [
    ['label' => 'Tableau de bord', 'icon' => 'bi-speedometer2', 'route' => 'dashboard'],
    ['label' => 'Ruchers',         'icon' => 'bi-diagram-3',    'route' => 'ruchers.index'],
    ['label' => 'Ruches',          'icon' => 'bi-hdd-stack',    'route' => 'ruches.index'],
    ['label' => 'Mesures',         'icon' => 'bi-graph-up',     'route' => 'mesures.index'],
    ['label' => 'Alertes',         'icon' => 'bi-bell',         'route' => 'alertes.index'],
    ['label' => 'Exports',         'icon' => 'bi-file-earmark-arrow-down', 'route' => 'exports.index'],
    ['label' => 'Utilisateurs',    'icon' => 'bi-people',       'route' => 'users.index'],
    ['label' => 'Profil',          'icon' => 'bi-person',       'route' => 'profile.edit'],
  ];
@endphp

<aside class="d-flex flex-column flex-shrink-0 p-3 bg-light border-end" style="width:260px;min-height:100vh;">
  <a href="{{ route('dashboard') }}" class="d-flex align-items-center mb-3 text-decoration-none">
    <span class="fs-5 fw-semibold">Projet Ruche</span>
  </a>
  <hr>
  <ul class="nav nav-pills flex-column mb-auto">
    @foreach ($items as $item)
      @if (\Illuminate\Support\Facades\Route::has($item['route']))
        @php $active = request()->routeIs($item['route']) ? 'active' : ''; @endphp
        <li class="nav-item">
          <a href="{{ route($item['route']) }}" class="nav-link {{ $active }}">
            <i class="bi {{ $item['icon'] }} me-2"></i>{{ $item['label'] }}
          </a>
        </li>
      @endif
    @endforeach
  </ul>
  <hr>
  <div class="dropdown">
    <a href="#" class="d-flex align-items-center link-dark text-decoration-none dropdown-toggle" data-bs-toggle="dropdown">
      <img src="https://ui-avatars.com/api/?name={{ urlencode(Auth::user()->name ?? 'U') }}" width="32" height="32" class="rounded-circle me-2">
      <strong>{{ Auth::user()->name ?? 'Utilisateur' }}</strong>
    </a>
    <ul class="dropdown-menu shadow">
      @if (\Illuminate\Support\Facades\Route::has('profile.edit'))
        <li><a class="dropdown-item" href="{{ route('profile.edit') }}">Paramètres</a></li>
      @endif
      <li><hr class="dropdown-divider"></li>
      <li>
        <form method="POST" action="{{ route('logout') }}"> @csrf
          <button class="dropdown-item">Déconnexion</button>
        </form>
      </li>
    </ul>
  </div>
</aside>