@extends('layouts.app_sidebar')
@section('title','Show')
@section('content')
<div class="p-3 bg-white border rounded-3 card-honey mb-3">
  <h1 class="h5 mb-0">{{ $rucher->nom }}</h1>
  <div class="text-muted">{{ $rucher->localisation }}</div>
  <div class="small">{{ $rucher->description }}</div>
</div>
<div class="bg-white border rounded-3">
  <table class="table table-hover align-middle mb-0">
    <thead class="table-light"><tr><th>Ruche</th><th>Installée</th><th>État</th><th></th></tr></thead>
    <tbody>
      @foreach($rucher->ruches as $ruche)
      <tr>
        <td class="fw-semibold">{{ $ruche->reference ?? ('Ruche #'.$ruche->id) }}</td>
        <td>{{ $ruche->date_installation }}</td>
        <td>{{ $ruche->etat }}</td>
        <td><a class="btn btn-sm btn-outline-primary" href="{{ route('ruches.show', $ruche) }}">Ouvrir</a></td>
      </tr>
      @endforeach
    </tbody>
  </table>
</div>
@endsection