<?php $__env->startSection('title', 'Dashboard — '.($ref ?? 'Ruche')); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto space-y-6">

  
  <div class="bg-white rounded-2xl shadow p-4">
    <div class="flex flex-col gap-3 md:flex-row md:items-center md:justify-between">
      <div>
        <h1 class="text-2xl font-bold">Dashboard — <span class="text-indigo-700"><?php echo e($ref ?? 'ruche-001'); ?></span></h1>
        <p class="text-sm text-gray-500">Visualisation des mesures et export CSV.</p>
      </div>

      <div class="flex flex-wrap items-center gap-2">
        
        <?php
          $ruchesArr = isset($ruches) && is_iterable($ruches) ? $ruches : [($ref ?? 'ruche-001')];
          $activeRef = $ref ?? (is_array($ruchesArr) ? ($ruchesArr[0] ?? 'ruche-001') : 'ruche-001');
        ?>

        <label class="text-sm text-gray-600">Ruche</label>
        <select id="refSelect" class="border rounded-lg px-3 py-2">
          <?php $__currentLoopData = $ruchesArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($r); ?>" <?php echo e($r === $activeRef ? 'selected' : ''); ?>><?php echo e($r); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

        
        <div class="hidden md:flex items-center gap-1">
          <button type="button" class="preset-btn px-2 py-1 text-sm rounded border" data-hours="12">12 h</button>
          <button type="button" class="preset-btn px-2 py-1 text-sm rounded border" data-hours="24">24 h</button>
          <button type="button" class="preset-btn px-2 py-1 text-sm rounded border" data-hours="168">7 j</button>
        </div>

        
        <input id="fromInput" type="datetime-local" class="border rounded-lg px-3 py-2" />
        <span class="text-gray-400">→</span>
        <input id="toInput" type="datetime-local" class="border rounded-lg px-3 py-2" />

        
        <button id="btn-apply" class="px-3 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700">
          Appliquer
        </button>
        <button id="btn-csv" type="button" class="px-3 py-2 rounded-lg border hover:bg-gray-50">
          Exporter CSV
        </button>
      </div>
    </div>
  </div>

  
  <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
    <div class="bg-white rounded-2xl shadow p-4">
      <div class="text-sm text-gray-500">Température (dernière)</div>
      <div id="kpi-temp" class="text-2xl font-semibold">—</div>
    </div>
    <div class="bg-white rounded-2xl shadow p-4">
      <div class="text-sm text-gray-500">Humidité (dernière)</div>
      <div id="kpi-hum" class="text-2xl font-semibold">—</div>
    </div>
    <div class="bg-white rounded-2xl shadow p-4">
      <div class="text-sm text-gray-500">Mesures</div>
      <div id="kpi-count" class="text-2xl font-semibold">—</div>
    </div>
    <div class="bg-white rounded-2xl shadow p-4">
      <div class="text-sm text-gray-500">Période</div>
      <div id="kpi-period" class="text-sm text-gray-700 leading-snug">—</div>
    </div>
  </div>

  
  <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
    
    <div class="bg-white rounded-2xl shadow p-4">
      <div class="flex items-center justify-between mb-2">
        <h3 class="font-semibold">Température & Humidité</h3>
      </div>
      <div class="relative" style="height: 320px">
        <canvas id="chartTH"></canvas>
      </div>
    </div>

    
    <div class="bg-white rounded-2xl shadow p-4">
      <div class="flex items-center justify-between mb-2">
        <h3 class="font-semibold">Poids & Batterie</h3>
      </div>
      <div class="relative" style="height: 320px">
        <canvas id="chartWB"></canvas>
      </div>
    </div>
  </div>

  
  <div class="bg-white rounded-2xl shadow p-4">
    <h3 class="font-semibold mb-3">Dernières mesures</h3>
    <div class="overflow-x-auto">
      <table class="min-w-full text-sm">
        <thead class="text-gray-600">
          <tr class="text-left border-b">
            <th class="py-2 px-3">Horodatage</th>
            <th class="py-2 px-3">Type</th>
            <th class="py-2 px-3">Valeur</th>
            <th class="py-2 px-3">Capteur</th>
          </tr>
        </thead>
        <tbody id="lastTableBody"></tbody>
      </table>
    </div>
  </div>

  
  <div id="msg" class="hidden p-3 rounded-lg bg-yellow-50 text-yellow-800 border border-yellow-200"></div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
  
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chartjs-adapter-date-fns@3"></script>

  <script>
  (function(){
    // --- Sélecteurs ---
    const refSel = document.querySelector('select[name="ref"], #refSelect, #ref-select, #ruche, #ruche-select');
    const fromI  = document.querySelector('#fromInput, #from-input, input[name="from"]');
    const toI    = document.querySelector('#toInput, #to-input, input[name="to"]');
    const btnApply = document.getElementById('btn-apply');
    const btnCsv   = document.getElementById('btn-csv');
    const presetBtns = document.querySelectorAll('.preset-btn');
    const serverRef = <?php echo json_encode($ref ?? 'ruche-001', 15, 512) ?>;

    // KPIs + msg
    const kpiTemp = document.getElementById('kpi-temp');
    const kpiHum  = document.getElementById('kpi-hum');
    const kpiCnt  = document.getElementById('kpi-count');
    const kpiPer  = document.getElementById('kpi-period');
    const msgBox  = document.getElementById('msg');

    // Charts
    let chartTH = null; // Temp + Hum
    let chartWB = null; // Weight + Battery

    // Couleurs fixes
    const COLORS = {
      temperature: '#3b82f6', // bleu
      humidity:    '#ec4899', // rose
      weight:      '#60a5fa', // bleu clair
      battery:     '#f472b6', // rose clair
    };

    const TYPE_ALIASES = {
      temperature: 'temperature', temp: 'temperature',
      humidity: 'humidity', humidite: 'humidity',
      weight: 'weight', poids: 'weight',
      battery: 'battery', batterie: 'battery', voltage: 'battery'
    };

    function showMsg(t) {
      if (!msgBox) return;
      msgBox.textContent = t || '';
      msgBox.classList.toggle('hidden', !t);
    }

    function fmtDateLabel(d) {
      try { return new Date(d).toLocaleString(); } catch { return d; }
    }

    function isoOrNull(inputEl) {
      if (!inputEl || !inputEl.value) return null;
      try { return new Date(inputEl.value).toISOString(); } catch { return null; }
    }

    function pickRef() {
      return (refSel && refSel.value) ? refSel.value : serverRef;
    }

    // === Dataset avec points visibles AU SURVOL + liaison des trous ===
    function buildDataset(label, color, points) {
      return {
        label,
        data: points,
        borderColor: color,
        backgroundColor: color,
        tension: 0.2,

        // points invisibles par défaut…
        pointRadius: 0,
        radius: 0,
        // …mais visibles au hover
        pointHoverRadius: 5,
        pointHitRadius: 10,
        pointHoverBorderWidth: 2,

        borderWidth: 2,
        parsing: false,

        // relie les segments même si quelques points manquent
        spanGaps: true,
      };
    }

    // --- Domaine X (pour coller l'axe aux données réelles) ---
    function computeXDomain(arrays) {
      let min = null, max = null;
      for (const arr of arrays) {
        if (!arr || !arr.length) continue;
        const aMin = arr[0].x;
        const aMax = arr[arr.length - 1].x;
        if (!min || aMin < min) min = aMin;
        if (!max || aMax > max) max = aMax;
      }
      if (min && max && +min === +max) {
        min = new Date(min.getTime() - 30*60*1000);
        max = new Date(max.getTime() + 30*60*1000);
      }
      return { min, max };
    }

    function renderCombinedTH(byType) {
      const el = document.getElementById('chartTH');
      if (!el) return;
      if (chartTH) chartTH.destroy();

      const tempPts = (byType.temperature ?? []).map(p => ({x:p.x, y:p.y}));
      const humPts  = (byType.humidity    ?? []).map(p => ({x:p.x, y:p.y}));

      const ds = [
        buildDataset('Température (°C)', COLORS.temperature, tempPts),
        buildDataset('Humidité (%)',     COLORS.humidity,    humPts),
      ];

      const { min: xMinTH, max: xMaxTH } = computeXDomain([tempPts, humPts]);

      const cfg = {
        type: 'line',
        data: { datasets: ds },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          parsing: false,
          interaction: { mode: 'index', intersect: false },
          scales: {
            x: {
              type: 'time',
              bounds: 'data',
              min: xMinTH || undefined,
              max: xMaxTH || undefined,
              time: { tooltipFormat: 'yyyy-MM-dd HH:mm' },
              ticks: { source: 'auto', maxTicksLimit: 8 }
            },
            y: { beginAtZero: false }
          },
          plugins: {
            legend: { display: true },
            tooltip: { intersect: false, position: 'nearest' }
          }
        }
      };

      try {
        chartTH = new Chart(el.getContext('2d'), cfg);
      } catch (err) {
        // fallback catégorie si time indispo
        const labels = (byType.temperature ?? byType.humidity ?? []).map(p => fmtDateLabel(p.x));
        const cfg2 = {
          type: 'line',
          data: {
            labels,
            datasets: [
              { ...buildDataset('Température (°C)', COLORS.temperature, []), data: tempPts.map(p => p.y) },
              { ...buildDataset('Humidité (%)', COLORS.humidity, []), data: humPts.map(p => p.y) },
            ]
          },
          options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: { mode: 'index', intersect: false },
            scales: { y: { beginAtZero: false } },
            plugins: { legend: { display: true }, tooltip: { intersect: false, position: 'nearest' } }
          }
        };
        chartTH = new Chart(el.getContext('2d'), cfg2);
      }
    }

    function renderCombinedWB(byType) {
      const el = document.getElementById('chartWB');
      if (!el) return;
      if (chartWB) chartWB.destroy();

      const weightPts = (byType.weight  ?? []).map(p => ({x:p.x, y:p.y}));
      const battPts   = (byType.battery ?? []).map(p => ({x:p.x, y:p.y}));

      const ds = [
        buildDataset('Poids (kg)',  COLORS.weight,  weightPts),
        buildDataset('Batterie (V)', COLORS.battery, battPts),
      ];

      const { min: xMinWB, max: xMaxWB } = computeXDomain([weightPts, battPts]);

      const cfg = {
        type: 'line',
        data: { datasets: ds },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          parsing: false,
          interaction: { mode: 'index', intersect: false },
          scales: {
            x: {
              type: 'time',
              bounds: 'data',
              min: xMinWB || undefined,
              max: xMaxWB || undefined,
              time: { tooltipFormat: 'yyyy-MM-dd HH:mm' },
              ticks: { source: 'auto', maxTicksLimit: 8 }
            },
            y: { beginAtZero: false }
          },
          plugins: {
            legend: { display: true },
            tooltip: { intersect: false, position: 'nearest' }
          }
        }
      };

      try {
        chartWB = new Chart(el.getContext('2d'), cfg);
      } catch (err) {
        const labels = (byType.weight ?? byType.battery ?? []).map(p => fmtDateLabel(p.x));
        const cfg2 = {
          type: 'line',
          data: {
            labels,
            datasets: [
              { ...buildDataset('Poids (kg)', COLORS.weight, []), data: weightPts.map(p => p.y) },
              { ...buildDataset('Batterie (V)', COLORS.battery, []), data: battPts.map(p => p.y) },
            ]
          },
          options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: { mode: 'index', intersect: false },
            scales: { y: { beginAtZero: false } },
            plugins: { legend: { display: true }, tooltip: { intersect: false, position: 'nearest' } }
          }
        };
        chartWB = new Chart(el.getContext('2d'), cfg2);
      }
    }

    function fillLastTable(series) {
      const tbody = document.getElementById('lastTableBody');
      if (!tbody) return;
      const rows = [...series].sort((a,b)=> new Date(b.measured_at) - new Date(a.measured_at)).slice(0, 10);
      tbody.innerHTML = rows.map(r => `
        <tr class="border-b">
          <td class="py-2 px-3">${fmtDateLabel(r.measured_at)}</td>
          <td class="py-2 px-3 capitalize">${(r.type ?? '').toString()}</td>
          <td class="py-2 px-3">${r.value}</td>
          <td class="py-2 px-3">${r.capteur_id ?? ''}</td>
        </tr>
      `).join('');
    }

    async function loadSeries() {
      showMsg('');

      const ref = pickRef();
      const fromIso = isoOrNull(fromI);
      const toIso   = isoOrNull(toI);
      const q = [];
      if (fromIso) q.push('from='+encodeURIComponent(fromIso));
      if (toIso)   q.push('to='+encodeURIComponent(toIso));
      const url = `/api/ruche/${encodeURIComponent(ref)}/series` + (q.length ? `?${q.join('&')}` : '');

      try {
        const r = await fetch(url, { headers: { 'Accept': 'application/json' }});
        if (!r.ok) throw new Error('HTTP '+r.status);
        const data = await r.json();

        const byType = {};
        const series = Array.isArray(data.series) ? data.series : [];
        for (const row of series) {
          const raw = (row.type ?? '').toString().toLowerCase();
          const key = TYPE_ALIASES[raw] ?? raw;
          (byType[key] ||= []).push({ x: new Date(row.measured_at), y: parseFloat(row.value) });
        }
        Object.values(byType).forEach(arr => arr.sort((a,b) => a.x - b.x));

        // KPIs
        kpiCnt && (kpiCnt.textContent = data.count ?? series.length ?? '—');
        kpiPer && (kpiPer.innerHTML =
          `<span class="text-gray-600">Du</span> ${fmtDateLabel(data.from ?? fromIso ?? '—')}
           <span class="text-gray-600">au</span> ${fmtDateLabel(data.to ?? toIso ?? '—')}`);

        const lastTemp = byType.temperature?.at(-1)?.y ?? null;
        const lastHum  = byType.humidity?.at(-1)?.y ?? null;
        kpiTemp && (kpiTemp.textContent = (lastTemp ?? '—'));
        kpiHum  && (kpiHum.textContent  = (lastHum  ?? '—'));

        // Graphes combinés
        renderCombinedTH(byType);
        renderCombinedWB(byType);

        // Tableau
        fillLastTable(series);

      } catch (e) {
        console.error(e);
        showMsg("Impossible de charger les données. Vérifie que l'API répond.");
      }
    }

    // Presets
    presetBtns.forEach(b => {
      b.addEventListener('click', () => {
        const hours = parseInt(b.dataset.hours || '24', 10);
        const to = new Date();
        const from = new Date(to.getTime() - hours * 60 * 60 * 1000);
        const toLocal = new Date(to.getTime() - to.getTimezoneOffset()*60000).toISOString().slice(0,16);
        const fromLocal = new Date(from.getTime() - from.getTimezoneOffset()*60000).toISOString().slice(0,16);
        if (fromI) fromI.value = fromLocal;
        if (toI)   toI.value   = toLocal;
      });
    });

    // Appliquer
    btnApply?.addEventListener('click', (e) => {
      e.preventDefault();
      loadSeries();
    });

    // Export CSV
    btnCsv?.addEventListener('click', function (e) {
      e.preventDefault();
      const ref = pickRef();
      let fromIso = isoOrNull(fromI);
      let toIso   = isoOrNull(toI);
      if (!fromIso || !toIso) {
        const toD = new Date();
        const fromD = new Date(toD.getTime() - 24 * 60 * 60 * 1000);
        toIso   = toD.toISOString();
        fromIso = fromD.toISOString();
      }
      const q = [];
      if (fromIso) q.push('from=' + encodeURIComponent(fromIso));
      if (toIso)   q.push('to='   + encodeURIComponent(toIso));
      const url = `/export/${encodeURIComponent(ref)}.csv` + (q.length ? `?${q.join('&')}` : '');
      window.location.href = url;
    });

    // Init 24h si vide
    if (fromI && toI && (!fromI.value || !toI.value)) {
      const now = new Date();
      const from = new Date(now.getTime() - 24*60*60*1000);
      const toLocal = new Date(now.getTime() - now.getTimezoneOffset()*60000).toISOString().slice(0,16);
      const fromLocal = new Date(from.getTime() - from.getTimezoneOffset()*60000).toISOString().slice(0,16);
      fromI.value = fromLocal;
      toI.value   = toLocal;
    }

    loadSeries();
  })();
  </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\wesne\ruche_connectee\projet_ruche\resources\views/dashboard.blade.php ENDPATH**/ ?>