<?php

namespace Tests\Feature;

use Tests\TestCase;
use Illuminate\Support\Facades\DB;

class TtnUplinkBinaryTest extends TestCase
{
    // ⚠️ Si tu n'as pas de migrations de test complètes, commente RefreshDatabase.
    // use Illuminate\Foundation\Testing\RefreshDatabase;
    // use RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();

        // Prépare un minimum de données si ta base de test est vide.
        // Si tu testes sur ta vraie base (ruche_db), commente ce seed minimal.
        if (!DB::table('ruches')->where('reference','ruche-001')->exists()) {
            $rucherId = DB::table('ruchers')->insertGetId([
                'nom' => 'Test',
                'created_at' => now(), 'updated_at' => now()
            ]);
            $rucheId = DB::table('ruches')->insertGetId([
                'rucher_id' => $rucherId,
                'reference' => 'ruche-001',
                'created_at' => now(), 'updated_at' => now()
            ]);
            DB::table('capteurs')->insert([
                ['ruche_id'=>$rucheId,'type'=>'temperature','unite'=>'°C','created_at'=>now(),'updated_at'=>now()],
                ['ruche_id'=>$rucheId,'type'=>'humidity','unite'=>'%','created_at'=>now(),'updated_at'=>now()],
            ]);
        }
    }

    public function test_webhook_inserts_and_is_idempotent()
    {
        $payload = [
            "end_device_ids" => ["device_id" => "ruche-001-node"],
            "received_at"    => now()->toIso8601String(),
            "uplink_message" => ["frm_payload" => "AR1CqA=="] // 27.6 & 68.0
        ];

        // 1) Premier envoi -> 200 ok
        $res1 = $this->postJson('/api/ttn/uplink', $payload, [
            'X-TTN-Secret' => env('TTN_SECRET', 'Hackagouwinners'),
            'Content-Type' => 'application/json',
        ]);
        $res1->assertStatus(200)->assertJsonPath('status','ok');

        // 2) Replay même timestamp -> si upsert: 200 ok (pas de 1062)
        $res2 = $this->postJson('/api/ttn/uplink', $payload, [
            'X-TTN-Secret' => env('TTN_SECRET', 'Hackagouwinners'),
            'Content-Type' => 'application/json',
        ]);
        $res2->assertStatus(200)->assertJsonPath('status','ok');
    }
}
