<?php

namespace Tests\Unit;

use PHPUnit\Framework\TestCase;
use App\Support\TtnV1;

class TtnDecoderTest extends TestCase
{
    public function test_decodes_temperature_and_humidity()
    {
        // Ce payload renvoie 28.5 °C et 68.0 %
        $data = TtnV1::decodeBase64('AR1CqA==');

        $this->assertArrayHasKey('temperature', $data);
        $this->assertArrayHasKey('humidity', $data);

        $this->assertEqualsWithDelta(28.5, $data['temperature'], 0.001);
        $this->assertEqualsWithDelta(68.0, $data['humidity'], 0.001);
    }

    public function test_negative_temperature_is_supported()
    {
        // -5.5°C & 70.0% (ton test actuel passe déjà)
        $b = self::packSegment(0b00, -55, true) . self::packSegment(0b01, 700, false);
        $data = TtnV1::decode($b);

        $this->assertEqualsWithDelta(-5.5, $data['temperature'], 0.001);
        $this->assertEqualsWithDelta(70.0, $data['humidity'], 0.001);
    }

    private static function packSegment(int $type2b, int $q1, bool $signed): string
    {
        if ($signed && $q1 < 0) $q1 = (1<<14) + $q1; // two's complement sur 14 bits
        $bits = [($type2b >> 1) & 1, $type2b & 1];
        $valBits = str_split(str_pad(decbin($q1), 14, '0', STR_PAD_LEFT));
        foreach ($valBits as $v) $bits[] = (int)$v;

        while (count($bits) % 8 !== 0) $bits[] = 0;
        $bytes = '';
        for ($i=0; $i<count($bits); $i+=8) {
            $byte = 0;
            for ($k=0; $k<8; $k++) $byte = ($byte<<1) | $bits[$i+$k];
            $bytes .= chr($byte);
        }
        return $bytes;
    }
}
