<?php namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Authenticatable;


class Capteur extends Model {
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'capteurs';


	public function getNomRucheAttribute() {
		$ruche=Ruche::find($this->id_ruche);
		if(!$ruche) return "";
		return $ruche->nom;
	}

	public function getNomTypeCapteurAttribute() {
		$type=TypeCapteur::find($this->id_type_capteur);
		if(!$type) return "";
		return $type->nom;
	}

	public function getNbMesuresAttribute() {
		$nb=Mesure::where('id_capteur','=',$this->id)->count();

		return $nb;
	}

	public function getLastMesureAttribute() {
		$mesure=Mesure::where('id_capteur','=',$this->id)->orderby('date','desc')->first();
		if(!$mesure) return "";
		return $mesure->date;
	}
}