<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Mesure;
use App\TypeCapteur;
use App\Capteur;
use App\Ruche;
//use App\Parametre;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use View;
//use Illuminate\Http\Request;
use App\Http\Requests\GenerateurRequest;

class DataGenerateurController extends Controller {
 
    private $menu='data_generateur';

    public function __construct()
    {
        //$this->beforeFilter('auth');
    }
 
    public function index()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

       $mesures=Mesure::where('id','!=','0')->orderby('id','DESC')->limit(200)->get();
       $liste_types_capteurs=TypeCapteur::select('id','nom')->orderby('nom','asc')->pluck('nom','id')->toArray();
       $liste_ruches=Ruche::select('id','nom')->orderby('nom','asc')->pluck('nom','id')->toArray();
        return View::make('generateur.index', [
            'user'=>$user,'menu' => $this->menu,
            'mesures' => $mesures, 
            "liste_types_capteurs" => $liste_types_capteurs,
            "liste_ruches" => $liste_ruches
             
        ]);
    }


     public function delete_data($id_ruche="",$id_capteur="")
    {
 
        if(($id_ruche=="")&&($id_capteur==""))
            Mesure::where("id","<>","0")->delete();
        if(($id_ruche!="")&&($id_capteur=="")) {
            $t_id_capteur_ruches=Capteur::select('id')->where('id_ruche','=',$id_ruche)->pluck('id')->toArray();
            Mesure::whereIn("id_capteur",$t_id_capteur_ruches)->delete();
        }
        if($id_capteur!="") {
           Mesure::where("id_capteur","=",$id_capteur)->delete();
        }

        $msg="Mesures supprimées";
        session()->flash('message', $msg);
        return redirect()->to('/generator');
    }


    public function generation(GenerateurRequest $request)
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );


        $heure_depart="1";
        $minutes_mesures="00";
        $date_debut=$request->date_debut;
        $nbjours=$request->nbjours;
        $id_ruche=$request->id_ruche;
        $nb_mesure_jour=$request->nb_mesure_jour;
        $id_type_capteur=$request->id_type_capteur;

        //Génération des sdonnées
        $ruche=Ruche::find($id_ruche);
        //Calcul de sheures de mesure
        $journee=24;
        $periode_mesure_minutes="";
        $periode_mesure=$journee/$nb_mesure_jour; //ex.6
        if($nb_mesure_jour>24) {
            $periode_mesure_minutes=$journee/$nb_mesure_jour*60;
        }

        for($i=0;$i<$nb_mesure_jour;$i++) {
            $t_heures[]=str_pad($heure_depart,2,"0",STR_PAD_LEFT).":".str_pad($minutes_mesures,2,"0",STR_PAD_LEFT);
            if($periode_mesure_minutes!="") {
                $minutes_mesures+=$periode_mesure_minutes;
                if($minutes_mesures>=60) {$minutes_mesures=0;$heure_depart+=1;}
                if($heure_depart==24) {$minutes_mesures=0;$heure_depart=0;}
                
            }
            else $heure_depart+=$periode_mesure;
        }

        //calcul des dates
        $date_debutUS=substr($date_debut,6,4)."-".substr($date_debut,3,2)."-".substr($date_debut,0,2);
        $t_dates_mesures=[];
        for($i=0;$i<$nbjours;$i++) {
            $new_date=date('Y-m-d', strtotime($date_debutUS. ' + '.$i.' days'));
            for($j=0;$j<$nb_mesure_jour;$j++) {
                $t_dates_mesures[]=$new_date." ".$t_heures[$j];
            }
            
        }

        //génération des données dans un tableau
        $nb_valeur=count($t_dates_mesures);

        if($id_type_capteur=="TOUS") {
            $capteurs=Capteur::where('id_ruche','=',$id_ruche)->get();
            $nb_create=0;
            foreach($capteurs as $capteur ) {
                $t_mesures=[];
                $type_capteur=TypeCapteur::find($capteur->id_type_capteur);
                $t_mesures[$type_capteur->nom][]=$this->dataParTypeCapteur($type_capteur->nom,$nb_valeur);
                //Onvide la table pour les data du capteur choisi
                Mesure::where("id_capteur","=",$capteur->id)->delete();
                //Ecriture dans la bdd
                foreach($t_mesures as $nom_type_capteur=>$t_data) {
                    for($i=0;$i<count($t_data[0]);$i++) {
                        $mesure = new Mesure;
                        $mesure->id_capteur=$capteur->id;
                        $mesure->date=$t_dates_mesures[$i];
                        $mesure->valeur=$t_data[0][$i];  
                        $mesure->save();
                        $nb_create++;
                    }
                }
            }
        }
        else {
            $capteur=Capteur::where('id_ruche','=',$id_ruche)->where('id_type_capteur','=',$request->id_type_capteur)->first();
            if(!$capteur) return redirect()->back()->withInput()->withErrors(['err'=>'Capteur introuvable']); ;   
            $type_capteur=TypeCapteur::find($request->id_type_capteur);
            $t_mesures[$type_capteur->nom][]=$this->dataParTypeCapteur($type_capteur->nom,$nb_valeur);

            //Onvide la table pour les data du capteur choisi
            Mesure::where("id_capteur","=",$capteur->id)->delete();

            //Ecriture dans la bdd
            $nb_create=0;
            foreach($t_mesures as $nom_type_capteur=>$t_data) {
                for($i=0;$i<count($t_data[0]);$i++) {

                    $mesure = new Mesure;
                    $mesure->id_capteur=$capteur->id;
                    $mesure->date=$t_dates_mesures[$i];
                    $mesure->valeur=$t_data[0][$i];  
                    $mesure->save();
                    $nb_create++;
                }
            }
        }

        $msg=$nb_create." données de ".$type_capteur->nom." ont été ajoutées sur la ruche ".$ruche->nom."!";
        session()->flash('message', $msg);
        return redirect()->to('/generator');
    }
 

    public function dataParTypeCapteur($type_capteur,$nb_valeur)
    {
        $max=0;$min=0;$precision=0;$valeur_dec=0;
        $t_mesures=[]; //https://www.wofrance.fr/weather/maps/city?LANG=fr&WMO=91592&ART=MXMN&CONT=aupa&R=0&LEVEL=150&REGION=0029&LAND=KL&NOREGION=0&MOD=&TMX=&TMN=&SON=&PRE=&MONAT=&OFFS=&SORT=


        //Humidité mesures entre 70% et 95%
        if($type_capteur=="Humidité") { 
            $max=97;$min=65;
        }
        //Pression entre 1000 et 1025
        if($type_capteur=="Pression") { 
            $max=1025;$min=1000;$precision=1;
        }
           
        //Temperature entre 15 et 40°C
        if($type_capteur=="Temperature") { 
            $max=40;$min=15;$precision=1;
        }

        //Masse
        if($type_capteur=="Masse") { 
            $max=55;$min=15;$precision=1;
        }

        //Luminosité
        if($type_capteur=="Luminosité") { 
            $max=100;$min=0;
        }    

        //ILS 0 ou 1
        if($type_capteur=="ILS") { 
            $max=1;$min=0;
        } 


        //Tension
        if($type_capteur=="Tension") { 
            $max=5;$min=1;$precision=1;
        } 

        for($i=0;$i<$nb_valeur;$i++) {
            if($precision>0) {
                $valeur_dec=rand()/(10*$precision);
                $valeur_dec=round($valeur_dec-intVal($valeur_dec),$precision);
            } 
            $valeur=rand($min, $max);
            $t_mesures[]=$valeur+$valeur_dec;
        }

        return $t_mesures;
    }
}



