<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Reception;
use App\Mesure;
use App\Ruche;
use App\TypeCapteur;
use App\Capteur;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use View;
use Illuminate\Http\Request;


class ReceptionController extends Controller {
 
    private $menu='data_recept';

    public function __construct()
    {
        //$this->beforeFilter('auth');
    }
 
    public function index($t_id_ruche="",$id_type_capteur="")
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

     
        $receptions=Reception::where('id','!=','0')->orderby('id','DESC')->limit(200)->get();

        return View::make('receptions.index', [
            'user'=>$user,'receptions'=>$receptions,'menu' => $this->menu,

        ]);
    }




     public function Data2Mesure()
    {
        $res=[];
        //Recherche des receptions qui ne sont pas dans mesures
        $receptions=Reception::all();
        foreach($receptions as $reception) {
            //Test si existe pas dans mesure
            $mesure=Mesure::where('id_reception','=',$reception->id)->first();
            if(!$mesure) {
                //Decoupage des valeurs
                $data_receipt=$reception->data;
                $t_data=explode(',',$data_receipt);
                $mac=trim($t_data[0]);
                $date=$reception->created_at->format('Y-m-d H:i:s');
                $type_capteur=[];
                $ruche=Ruche::where("mac","=",$mac)->first(); //7C:9E:BD:39:B3:58

                if($ruche) {
                    //Temperature
                    $type_capteur["T"]=TypeCapteur::where('nom','=','Temperature')->first();
                    $valeur["T"]=$t_data[1];

                    //Humidité
                    $type_capteur["H"]=TypeCapteur::where('nom','=','Humidité')->first();
                    $valeur["H"]=$t_data[2];

                    //Pression
                    $type_capteur["P"]=TypeCapteur::where('nom','=','Pression')->first();
                    $valeur["P"]=$t_data[3];


                    //Masse
                    $type_capteur["M"]=TypeCapteur::where('nom','=','Masse')->first();
                    $valeur["M"]=$t_data[4];


                    //Luminosité
                    $type_capteur["L"]=TypeCapteur::where('nom','=','Luminosité')->first();
                    $valeur["L"]=$t_data[6];


                    //Ouverture & Fermeture
                    $type_capteur["I"]=TypeCapteur::where('nom','=','ILS')->first();
                    $valeur["I"]=$t_data[7];

                    //Tension
                    $type_capteur["U"]=TypeCapteur::where('nom','=','Tension')->first();
                    $valeur["U"]=$t_data[8];

                    foreach($type_capteur as $key=>$type) {
                        $capteur=Capteur::where('id_type_capteur','=',$type->id)->where('id_ruche','=',$ruche->id)->first();
                        if($capteur) $res[]=$this->insertMesure($capteur->id,$valeur[$key],$reception->id,$date);
                    }       
                }
            }
        }
        $msg=count($res)." Ligne ajoutées dans mesures";
        return Redirect::back()->with('message', $msg);
    }


    public function insertMesure($id_capteur,$valeur,$id_reception,$date)
    {
        $mesure=new Mesure();
        $mesure->id_capteur=$id_capteur;
        $mesure->id_reception=$id_reception;
        $mesure->date=$date;
        $mesure->valeur=$valeur;
        $mesure->save();
        return $mesure->id;
    }




    public function create()
    {


    }
 
    public function store(MesureRequest $request)
    {

    }
 
    public function edit($id)
    {

    }
 

    public function update($id,MesureRequest $request)
    {

    }
 
    public function show($id)
    {

    }

    public function destroy($id)
    {

    }
 

}



