<?php namespace App\Http\Requests;
 
use Illuminate\Foundation\Http\FormRequest;
 
class LoginRequest extends FormRequest {
    public function rules() {
        return [
            'email' => 'required' ,
            'password' => 'required' ,
        ];
    }
 
    public function remember() {
        return $this->has( 'remember' );
    }
 
    public function credentials() {
        return $this->only( 'email' , 'password' );
    }
 
    public function authorize() {
        return true;
    }
}