@extends('layouts.dash')

@section('title') Generateur @stop
@section('title_card',"Générateur de Donnée ")
@section('subtitle_card',"Liste complète")



@section('content')

<div class="row">
    <!-- left column -->
    <div class="col-md-6">
        <!-- general form elements -->
        <div class="card card-primary">
        <div class="card-header">
        <h3 class="card-title"><font style="vertical-align: inherit;"><font style="vertical-align: inherit;">Paramêtres de génération</font></font></h3>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
        {!! Form::open(['class' => 'form-horizontal', 'url' => '/generator']) !!}
            <div class="form-group row">
                <div class="col-md-4">
                    {!! Form::label('id_ruche', 'Ruche') !!}
                    {!! Form::select('id_ruche',$liste_ruches,"",['id'=>'id_ruche','placeholder' => 'A définir','class' => 'form-control',]) !!}
                </div>                   

                <div class="col-md-4">
                    {!! Form::label('date_debut', 'Date début') !!}
                    {!! Form::text('date_debut', date('d/m/Y'), ['placeholder' => 'Date', 'class' => 'form-control']) !!}
                </div>
                <div class="col-md-4">
                    {!! Form::label('nbjours', 'Nombre de jours') !!}
                    {!! Form::text('nbjours', null, ['placeholder' => 'Nombre', 'class' => 'form-control']) !!}
                </div>                    
            </div>
            <div class="form-group row">
                <div class="col-md-6">
                {!! Form::label('nb_mesure_jour', 'Nb mesures par jour') !!}
                {!! Form::text('nb_mesure_jour', null, ['placeholder' => 'Nombre', 'class' => 'form-control']) !!}
                </div>

                <div class="col-md-6">
                {!! Form::label('id_type_capteur', 'Type Capteur') !!}
                {!! Form::select('id_type_capteur',$liste_types_capteurs+["TOUS"=>"Tous"],"",['placeholder' => 'A définir','class' => 'form-control',]) !!}
                </div>
            </div>
            <div class='form-group row'>
                    {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
                    <a onclick='delete_mesure()' class="btn btn-danger" href="" >Supprimer les données</a>
            </div>
            <script>

                function delete_mesure() {
                    var e = document.getElementById("id_ruche");
                    var value = e.options[e.selectedIndex].value;     
                    var url="{!! url('delete_data') !!}"+"/"+value;
                    location.href=url;
                }
            </script>
        {!! Form::close() !!}
        </div>
        <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
    <!--/.col (left) -->

    <!-- right column -->
    <div class="col-md-6">
        <!-- Form Element sizes -->
        <div class="card card-success">
        <div class="card-header">
        <h3 class="card-title"><font style="vertical-align: inherit;"><font style="vertical-align: inherit;">Mesures</font></font></h3>
        </div>
        <div class="card-body">
        <table id="_table" width="100%" class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th>Id</th>
                    <th>Ruche</th>
                    <th>Capteur</th>
                    <th>Type de mesure</th>
                    <th>Valeur</th>
                    <th>Date</th>

                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($mesures as $mesure)
                <tr>
                    <td nowrap>
                        <a href="{!! url('mesures/'.$mesure->id) !!}" >{!! $mesure->id !!}</a>
                    </td>
                    <td nowrap>{!! $mesure->NomRuche !!}</td>
                    <td nowrap>{!! $mesure->NomCapteur !!}</td>
                    <td nowrap>{!! $mesure->NomTypeMesure !!}</td>
                    <td nowrap>{!! $mesure->valeur !!}</td>
                    <td nowrap>{!! $mesure->date !!}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
        </div>
        <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
<!--/.col (right) -->
</div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable")
@endsection