@extends('layouts.dash')

@section('title') Data @stop
@section('title_card',"Data")
@section('subtitle_card',"Données reçues")
@section('content')
    <div class="card">

@if (session('message'))
    <div class="alert alert-success">
        {{ session('message') }}
    </div>
@endif

        <div class="card-body">
            <table id="_table" width="100%" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Données</th>
                        <th>Date</th>
                        <th>Mesure</th>
                    </tr>
                </thead>
                <tbody>
                    
                    @foreach ($receptions as $reception)

                    <tr>
                        <td nowrap>{!! $reception->id !!}</td>
                        <td nowrap>{!! $reception->data !!}</td>
                        <td nowrap>{!! $reception->created_at !!}</td>
                        <td nowrap>{!! $reception->HasMesure !!}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

    </div>


    <a class="btn btn-success" href="{!! url('import_data') !!}">
        Importer les données dans Mesures
    </a>
    <a class="btn btn-danger" href="{!! url('api/api_delete_data') !!}" onclick="if(!confirm('Voulez-vous supprimer toutes les données définitivement ?')) return false;">
        <span class='ti-trash'></span>
    </a>
@endsection


@section('scripts')
    @include("forms.scripts_datatable")
@endsection