@extends('layouts.dash')

@section('title') Ruches @stop
@section('title_card',"Ruches")
@section('content')
    <div class="card">
        <div class="card-body">
            <table id="_table" width="100%" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th width='10%' >Nom</th>
                        <th width='1%' >MAC</th>
                        <th>Position</th>
                        <th>Nb Capteurs</th>
                        <th>Nb Mesures</th>
                        <th>Poids actuel</th>
                        <th>Dernière Mesures</th>
                        <th width='75px'>
                            <a href="{!! url('ruches/create') !!}" class="btn btn-success">
                                <span class='ti-plus'></span></a> 
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($ruches as $ruche)
                    <tr>
                        <td nowrap>
                            <a href="{!! url('ruches/'.$ruche->id) !!}" >{!! $ruche->nom !!}</a>
                        </td>
                        <td nowrap>{!! $ruche->mac !!}</td>
                        <td nowrap>{!! $ruche->gps !!}</td>
                        <td nowrap>{!! $ruche->NbCapteurs !!}</td>
                        <td nowrap>{!! $ruche->NbMesures !!}</td>
                        <td nowrap>{!! $ruche->PoidsActuel !!}</td>
                        <td nowrap>{!! $ruche->LastMesure !!}</td>
                        <td nowrap>
                            <a href="./ruches/{!! $ruche->id !!}/edit" class="btn btn-info pull-left" style="margin-right: 3px;">
                                <span class='ti-pencil-alt'></span>
                            </a>

                            {!! Form::open(['url' => url('ruches/' . $ruche->id), 'method' => 'DELETE']) !!}
                                {{ csrf_field() }}
                                <button class="btn btn-danger">
                                    <span class='ti-trash'></span>
                                </button>
                            {!! Form::close() !!}
                        
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable")
@endsection