@extends('layouts.dash')
@section('title') Rôles @stop
@section('title_card',"")
@section('content')

    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    <div class="card">
        <div class="card-header bg-info">
            <h3>Rôles</h3>
        </div>
        <div class="card-body">

            <div class="row">
                <div class="col-md-12">
                <table id="_table" width="100%" class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th >Nom</th>
                            <th >Utilisateurs</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($roles as $role)
                        <tr>
                            <td>
                                <a href="{!! url('roles/'.$role->id) !!}" >{!! $role->name !!}</a>
                            </td>
                            <td style=''>{!! $role->NomUsers !!}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                </div>
            </div>
            @if($user->hasRole("ADMINISTRATEUR")|| $user->can("ROL_AJO"))
            <a href="{!! url('roles/create') !!}" class="btn btn-sm btn-success">
                <span class='fa fa-plus'></span>&nbsp;Ajouter un Rôle</a>
            @endif
        </div>
    </div>
@endsection


@section('scripts')
<script>
  $(function () {
    $("#_table").DataTable({
      "paging": false,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": false,
      "responsive": false, 
      "autoWidth": false,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }

        },
        //"buttons": ["copy", "excel", "colvis"] //"print", "pdf", "csv", 
    })
    .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

  });
</script>

@endsection



