@extends('layouts.dash')
@section('title') Utilisateur @stop

@section('content')
    <div class="card card-success">
        <div class="card-header">
            <h2>Utilisateur <span style='color:darkblue'>{!! $user_sel->nomcomplet !!}</span></h2>
        </div>
        <div class='card-body'>
            @if ($errors)
                @foreach ($errors->all() as $error)
                    <div class='bg-danger alert'>{!! $error !!}</div>
                @endforeach
            @endif
            {{ html()->modelForm($user_sel, 'PUT', url('/users/' . $user_sel->id))->open() }}
                @include("acces.users.content")
            {{ html()->closeModelForm() }}
        </div>
    </div>
@stop

@section('scripts')
    <script>
        $(function() {
            $('.select2').select2();
        })
    </script>
@stop
