<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Alerte extends Model
{
    use HasFactory;

    protected $fillable = [
        'ruche_id',
        'capteur_id',
        'type',
        'niveau',
        'message',
        'triggered_at',
        'resolved_at',
    ];

    protected $casts = [
        'triggered_at' => 'datetime',
        'resolved_at' => 'datetime',
    ];

    public function ruche()
    {
        return $this->belongsTo(\App\Models\Ruche::class);
    }

    public function capteur()
    {
        return $this->belongsTo(\App\Models\Capteur::class);
    }
}
