<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('alert_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ruche_id')->constrained('ruches')->cascadeOnDelete();
            $table->double('temp_min')->nullable();
            $table->double('temp_max')->nullable();
            $table->double('humidity_min')->nullable();
            $table->double('humidity_max')->nullable();
            $table->timestamps();

            $table->unique('ruche_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('alert_settings');
    }
};