<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // === ALERT_SETTINGS ===
        if (!Schema::hasTable('alert_settings')) {
            Schema::create('alert_settings', function (Blueprint $table) {
                $table->id();
                $table->foreignId('ruche_id')->constrained()->cascadeOnDelete();
                $table->string('type'); // temperature, humidity, weight, battery
                $table->decimal('threshold_min', 8, 2)->nullable();
                $table->decimal('threshold_max', 8, 2)->nullable();
                $table->decimal('hysteresis', 5, 2)->default(0.5);
                $table->boolean('enabled')->default(true);
                $table->timestamps();
            });
        } else {
            // Ajoute les colonnes manquantes si la table existe déjà
            Schema::table('alert_settings', function (Blueprint $table) {
                if (!Schema::hasColumn('alert_settings','ruche_id')) {
                    $table->foreignId('ruche_id')->after('id')->constrained()->cascadeOnDelete();
                }
                if (!Schema::hasColumn('alert_settings','type')) {
                    $table->string('type')->after('ruche_id');
                }
                if (!Schema::hasColumn('alert_settings','threshold_min')) {
                    $table->decimal('threshold_min', 8, 2)->nullable()->after('type');
                }
                if (!Schema::hasColumn('alert_settings','threshold_max')) {
                    $table->decimal('threshold_max', 8, 2)->nullable()->after('threshold_min');
                }
                if (!Schema::hasColumn('alert_settings','hysteresis')) {
                    $table->decimal('hysteresis', 5, 2)->default(0.5)->after('threshold_max');
                }
                if (!Schema::hasColumn('alert_settings','enabled')) {
                    $table->boolean('enabled')->default(true)->after('hysteresis');
                }
                if (!Schema::hasColumn('alert_settings','created_at')) {
                    $table->timestamps();
                }
            });
        }

        // === ALERTS ===
        if (!Schema::hasTable('alerts')) {
            Schema::create('alerts', function (Blueprint $table) {
                $table->id();
                $table->foreignId('ruche_id')->constrained()->cascadeOnDelete();
                $table->string('type');
                $table->dateTime('measured_at');
                $table->decimal('value', 8, 2);
                $table->enum('level', ['low','high']);
                $table->timestamp('ack_at')->nullable();
                $table->timestamps();
            });
        } else {
            Schema::table('alerts', function (Blueprint $table) {
                if (!Schema::hasColumn('alerts','ruche_id')) {
                    $table->foreignId('ruche_id')->after('id')->constrained()->cascadeOnDelete();
                }
                if (!Schema::hasColumn('alerts','type')) {
                    $table->string('type')->after('ruche_id');
                }
                if (!Schema::hasColumn('alerts','measured_at')) {
                    $table->dateTime('measured_at')->after('type');
                }
                if (!Schema::hasColumn('alerts','value')) {
                    $table->decimal('value', 8, 2)->after('measured_at');
                }
                if (!Schema::hasColumn('alerts','level')) {
                    // Si ta BDD n'aime pas enum ici, remplace par $table->string('level', 10)
                    $table->enum('level', ['low','high'])->after('value');
                }
                if (!Schema::hasColumn('alerts','ack_at')) {
                    $table->timestamp('ack_at')->nullable()->after('level');
                }
                if (!Schema::hasColumn('alerts','created_at')) {
                    $table->timestamps();
                }
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('alerts')) {
            Schema::drop('alerts');
        }
        if (Schema::hasTable('alert_settings')) {
            Schema::drop('alert_settings');
        }
    }
};
