<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        if (Schema::hasTable('mesures') && !Schema::hasColumn('mesures', 'value_raw')) {
            Schema::table('mesures', function (Blueprint $table) {
                $table->string('value_raw')->nullable()->after('value_numeric');
            });
        }
    }

    public function down(): void {
        if (Schema::hasTable('mesures') && Schema::hasColumn('mesures', 'value_raw')) {
            Schema::table('mesures', function (Blueprint $table) {
                $table->dropColumn('value_raw');
            });
        }
    }
};
